package org.lixm.core.model;

import org.lixm.core.common.XMLType;



/**
 * <p>コメントをモデル化します。</p>
 * @author tasogare
 * @version 1.1.2
 */
public class CommentModel extends AbstractModel {

    private String text;

    public CommentModel(
        String text)
    {
        super(XMLType.COMMENT);
        this.text = text;
    }

    /**
     * <p>コメントのテキスト部分を取得します。</p>
     * 
     * @return コメントテキスト
     */
    public String getText() {
        return text;
    }

    /**
     * <p>コメントのテキスト部分を設定します。</p>
     * 
     * @param text 新たなコメントのテキスト部分
     */
    public void setText(String text){
    	this.text = text;
    }

    /**
     * {@inheritDoc}
     */
    public String toString() {
        return "<!-- " + text + " -->";
    }

    /**
     * <p>モデルの同一性を論理的に調べその結果を返します。</p>
     * @return 同一のモデルなら<code>true</code>、違うなら<code>false</code>。
     */
    public boolean equals(
        Object o)
    {
        if (!super.equals(o)) return false;
        return ( this.toString( ) == o.toString( ) );
    }
}
