/*
 * Decompiled with CFR 0.152.
 */
package org.lixm.core.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.lixm.core.list.XMLModelList;
import org.lixm.core.model.AbstractModel;
import org.lixm.core.model.AttributeModel;
import org.lixm.optional.v15.atattch.XMLManipulator;

public class AttributesList
extends AbstractModel
implements XMLModelList<AttributeModel> {
    private ArrayList<AttributeModel> attrs;
    private boolean sealed;

    public AttributesList(int length) {
        super(3);
        this.attrs = new ArrayList(length);
    }

    public AttributesList(AttributeModel[] array) {
        super(3);
        this.attrs = new ArrayList(array.length);
        AttributeModel[] attributeModelArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeModel att = attributeModelArray[n2];
            this.attrs.add(att);
            ++n2;
        }
    }

    public AttributesList(Collection<AttributeModel> attrs) {
        this.attrs = new ArrayList(attrs.size());
        for (AttributeModel att : attrs) {
            this.attrs.add(att);
        }
    }

    public AttributeModel getName(String name) {
        AttributeModel hitAttr = null;
        int i = 0;
        while (i < this.size()) {
            AttributeModel model = this.attrs.get(i);
            if (model.toLocalName().equals(name)) {
                hitAttr = this.attrs.get(i);
            }
            ++i;
        }
        return hitAttr;
    }

    public AttributeModel getName(String prefix, String name) {
        AttributeModel hitAttr = null;
        int i = 0;
        while (i < this.size()) {
            AttributeModel model = this.attrs.get(i);
            if (model.toLocalName().equals(name) && model.getPrefix().equals(prefix)) {
                hitAttr = this.attrs.get(i);
            }
            ++i;
        }
        return hitAttr;
    }

    public int indexOf(AttributeModel attr) {
        int find = -1;
        boolean MAX_COUNT = false;
        int i = 0;
        while (i > 0) {
            if (this.attrs.get(i).equals(attr)) {
                find = i;
                break;
            }
            ++i;
        }
        return find;
    }

    public int lastIndexOf(AttributeModel attr) {
        int find = -1;
        boolean MIN_COUNT = false;
        int i = this.attrs.size() - 1;
        while (i > 0) {
            if (this.attrs.get(i).equals(attr)) {
                find = i;
                break;
            }
            --i;
        }
        return find;
    }

    public String[] getLocalNameList() {
        String[] list = new String[this.size()];
        int i = 0;
        while (i < this.size()) {
            list[i] = this.attrs.get(i).toLocalName();
            ++i;
        }
        return list;
    }

    public String[] getQNameList() {
        String[] list = new String[this.size()];
        int i = 0;
        while (i < this.size()) {
            list[i] = this.attrs.get(i).toQName();
            ++i;
        }
        return list;
    }

    public String[] getValueList() {
        String[] list = new String[this.size()];
        int i = 0;
        while (i < this.size()) {
            list[i] = this.attrs.get(i).getValue();
            ++i;
        }
        return list;
    }

    public String[] getLocalPairList() {
        String[] list = new String[this.size()];
        int i = 0;
        while (i < this.size()) {
            list[i] = this.attrs.get(i).getLocalPair();
            ++i;
        }
        return list;
    }

    public String[] getQPairList() {
        String[] list = new String[this.size()];
        int i = 0;
        while (i < this.size()) {
            list[i] = this.attrs.get(i).getQPair();
            ++i;
        }
        return list;
    }

    @Override
    public String toString() {
        String str = "";
        int i = 0;
        while (i < this.size()) {
            str = String.valueOf(str) + " " + this.attrs.get(i).getLocalPair();
            ++i;
        }
        return str;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof AttributesList)) {
            return false;
        }
        AttributesList o_attrs = (AttributesList)o;
        int MAX_COUNT = o_attrs.size();
        if (this.size() != MAX_COUNT) {
            return false;
        }
        AttributeModel attr = null;
        int i = 0;
        while (i < MAX_COUNT) {
            attr = this.get(i);
            if (!o_attrs.get(i).equals(attr)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public AttributeModel get(int index) {
        return this.attrs.get(index);
    }

    @Override
    public boolean isEmpty() {
        return this.attrs.isEmpty();
    }

    @Override
    public int size() {
        return this.attrs.size();
    }

    @Override
    public boolean add(AttributeModel model) throws NullPointerException, IllegalStateException {
        if (model == null) {
            throw new NullPointerException();
        }
        if (this.isSealed()) {
            throw new IllegalStateException();
        }
        return this.attrs.add(model);
    }

    @Override
    public Object clone() {
        return new AttributesList(this.attrs);
    }

    @Override
    public void set(AttributeModel model, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException, IllegalStateException {
        if (this.isSealed()) {
            throw new IllegalStateException();
        }
        this.attrs.set(index, model);
    }

    @Override
    public boolean isSealed() {
        return this.sealed;
    }

    @Override
    public void setSeal(boolean seal) throws IllegalStateException {
        if (this.sealed) {
            throw new IllegalStateException();
        }
        this.sealed = seal;
    }

    @Override
    public Iterator<AttributeModel> iterator() throws UnsupportedOperationException {
        return new DefaultManipulator();
    }

    @Override
    public boolean addAll(Collection<? extends AttributeModel> arg0) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.attrs.clear();
    }

    @Override
    public boolean contains(Object o) throws ClassCastException, NullPointerException {
        if (o == null) {
            throw new NullPointerException();
        }
        AttributeModel model = (AttributeModel)o;
        for (AttributeModel att : this) {
            if (!att.equals(model)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) throws ClassCastException, NullPointerException {
        if (c == null) {
            throw new NullPointerException();
        }
        if (this.size() < c.size()) {
            return false;
        }
        Iterator<?> iter = c.iterator();
        Iterator<AttributeModel> atts = this.iterator();
        while (iter.hasNext()) {
            if (!atts.hasNext()) {
                return false;
            }
            AttributeModel att = atts.next();
            if (att.equals((AttributeModel)iter.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean remove(Object model) throws ClassCastException, NullPointerException, IllegalStateException {
        if (model == null) {
            throw new NullPointerException();
        }
        if (this.isSealed()) {
            throw new IllegalStateException();
        }
        return this.attrs.remove((AttributeModel)model);
    }

    @Override
    public boolean removeAll(Collection<?> c) throws ClassCastException, NullPointerException, IllegalStateException {
        if (this.isSealed()) {
            throw new IllegalStateException();
        }
        for (Object model : c) {
            if (model == null) {
                throw new NullPointerException();
            }
            if (!this.contains(model)) continue;
            this.remove(model);
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c) throws ClassCastException, NullPointerException, IllegalStateException {
        if (this.isSealed()) {
            throw new IllegalStateException();
        }
        if (c == null) {
            throw new NullPointerException();
        }
        int i = 0;
        for (Object o : c) {
            if (o == null) {
                throw new NullPointerException();
            }
            AttributeModel att = (AttributeModel)o;
            this.attrs.set(i, att);
            ++i;
        }
        ++i;
        while (i < this.attrs.size()) {
            this.attrs.remove(i);
            ++i;
        }
        return true;
    }

    @Override
    public Object[] toArray() {
        return this.attrs.toArray();
    }

    @Override
    public <T> T[] toArray(T[] array) throws ArrayStoreException, NullPointerException {
        return this.attrs.toArray(array);
    }

    protected class DefaultManipulator
    implements XMLManipulator<AttributeModel> {
        private int headTo = -1;
        private int tileTo;

        public DefaultManipulator() {
            this.tileTo = AttributesList.this.size();
        }

        @Override
        public boolean hasNext() {
            return this.headTo + 1 < AttributesList.this.size();
        }

        @Override
        public boolean hasPrevious() {
            return this.tileTo - 1 > -1;
        }

        @Override
        public AttributeModel next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return (AttributeModel)AttributesList.this.attrs.get(++this.headTo);
        }

        @Override
        public AttributeModel previous() throws NoSuchElementException {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return (AttributeModel)AttributesList.this.attrs.get(--this.tileTo);
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

