package org.pigeonblood.impl.optional.cnif;

import java.util.Stack;

import org.lixm.core.common.LIXMException;
import org.lixm.core.common.LIXMPhaseException;
import org.lixm.core.list.XMLDocumentList;
import org.lixm.core.model.XMLModel;
import org.lixm.optional.v16.framework.cnif.XMLIndexer;
import org.pigeonblood.impl.core.list.SimpleDocumentList;

/**
 * <p>XMLCfNT̒PȒێłB</p>
 * 
 * <p>RXgN^̈ɂ͐VɃCfbNXꂽfi[邽߂ɋ̃Xgn܂B</p>
 * 
 * <p>fN[[̎擾ł͂ȂA RtꂽԂŊi[ꍇ
 * {@link #compare(XMLModel, XMLModel)} 
 * {@link #receive(XMLModel)}
 * {@linkplain #compare(XMLModel, XMLModel)} 𗘗p悤ɍĎĂB</p>
 * 
 * <p>ʏ̎ł{@linkplain #compare(XMLModel, XMLModel)}͗pĂ܂B
 * ܂AKv͂܂B</p>
 * 
 * @author tasogare
 * @since 0.2
 */
public abstract class AbstractXMLIndexer implements XMLIndexer<XMLModel> {

	private Stack<XMLModel> stack;
	private SimpleDocumentList list;

	private boolean stackFull = false;

//	private AbstractXMLIndexer() {
//	}

	/**
	 * <p>B̃RXgN^łB</p>
	 * 
	 * @param list
	 *        N[ɑIꂽfi[VȃXg
	 */
	public AbstractXMLIndexer(SimpleDocumentList list) {
		this.list = list;
		stack = new Stack<XMLModel>();
	}

	/**
	 * {@inheritDoc}
	 */
	public abstract int compare(XMLModel arg0, XMLModel arg1)
			throws UnsupportedOperationException;

	/**
	 * {@inheritDoc}
	 */
	@SuppressWarnings("unchecked")
	public <E extends XMLModel> XMLDocumentList<E> getList()
			throws LIXMPhaseException {
		SimpleDocumentList list = demandList();

		if (list == null) {
			throw new LIXMPhaseException(
					new NullPointerException("XgnullłB"),
					LIXMPhaseException.PHASE_OTHER);
		}

		return (XMLDocumentList<E>) list;
	}

	/**
	 * <p>N[ɂĐVȃXgɉ郂fIA CfNTɃfBXpb`܂B</p>
	 * 
	 * <p>̂ƂɎ󂯎̂̃\bhłB</p>
	 * 
	 * @param model
	 *        N[If
	 */
	public void receive(XMLModel model) throws LIXMException {
		if (model == null) {
			throw new LIXMException(new NullPointerException());
		}

		stack.push(model);
		// demandList( );
	}

	/**
	 * <p>X^bNƃXg̃TCYvX^bN烊Xgփf߂ÃXgԂB
	 * łȂꍇ<code>null</code>ԂB</p>
	 */
	protected final SimpleDocumentList demandList() {
		/*
		 * O
		 */
		if (stackFull){
			return list;
		} else {
			list.addAll(stack);
			list.setSeal(true);
			stackFull = true;
			return list;
		}
	}

}
