package org.pigeonblood.test;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;

public final class Test0Handler extends DefaultHandler2 {

	public void startDocument() throws SAXException {
		System.out.println("start document");
	}

	public void endDocument() throws SAXException {
		System.out.println("end document");
	}

	public void startPrefixMapping(String prefix, String uri)
			throws SAXException {
		System.out.println("start prefix");
		System.out.println("\t" + "prefix : " + prefix);
		System.out.println("\t" + "uri : " + uri);
	}

	public void endPrefixMapping(String prefix) throws SAXException {
		System.out.println("end prefix");
		System.out.println("\t" + "prefix : " + prefix);
	}

	public void startElement(String uri, String localName, String qName,
			Attributes attributes) throws SAXException {
		System.out.println("start element");
		System.out.println("\t" + "uri : " + uri);
		System.out.println("\t" + "local name : " + localName);
		System.out.println("\t" + "q name : " + qName);
		System.out.println("\t\t" + "attributes : " + attributes.toString());

	}

	public void endElement(String uri, String localName, String qName)
			throws SAXException {
		System.out.println("\t" + "uri : " + uri);
		System.out.println("\t" + "local name : " + localName);
		System.out.println("\t" + "q name : " + qName);
	}

	public void characters(char[] ch, int start, int length)
			throws SAXException {
		System.out.println(new String(ch, start, length));
	}

	public void ignorableWhitespace(char[] ch, int start, int length)
			throws SAXException {
		System.out.println("ignorable whitespace count : " + length);
	}

	public void processingInstruction(String target, String data)
			throws SAXException {
		System.out.println("PI");
		System.out.println("\t" + target + " " + data);
	}

	public void skippedEntity(String name) throws SAXException {
		System.out.println("skipped entity : " + name);
	}

	public void startEntity(String name) throws SAXException {
		System.out.println("start entity : " + name);
	}

	public void endEntity(String name) throws SAXException {
		System.out.println("end entity : " + name);
	}

	public void comment(char[] ch, int start, int length) throws SAXException {
		System.out.println("comment");
	}
}
