#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define DUMMY_MACRO_STRINGIFY(s) # s
#define STRINGIFY(s) DUMMY_MACRO_STRINGIFY(s)

#ifdef BFD_VERSION
#define KL_BFD_VERSION_STRING STRINGIFY(BFD_VERSION)
#else
#include <bfd.h>
#define KL_BFD_VERSION_STRING BFD_VERSION
#endif

/* make sure that this macro is similarly defined in 
 * lcrash/include/lc_config.h
 */
#define _BFD_VERSION_NUMBER_(a,b,c) (((a) << 24) + ((b) << 12) + (c))

int main(void)
{
	int v1, v2, v3;
	char* tok;
	char* version;

#ifdef BFD_VERSION_STRING
	version=strdup(BFD_VERSION_STRING);
#else
	/*
	 * in new versions bfd.h contains BFD_VERSION and BFD_VERSION_STRING,
	 * we still parse the version string to use our own version number
	 */
	version=strdup(KL_BFD_VERSION_STRING);
#endif
	if(!version){
		return(1);
	}

	tok=strtok(version, ".");
	if(!tok){
		return(1);
	}

	v1=atoi(tok);

	tok=strtok(NULL, ".");
	if(!tok){
		return(1);
	}
	v2=atoi(tok);

	tok=strtok(NULL, ".");
	if(!tok){
                v3 = 0;
	}
	else v3=atoi(tok);

	printf("%d", _BFD_VERSION_NUMBER_(v1, v2, v3));
	return(0);
}
