/*
 * Copyright 1999 Silicon Graphics, Inc. All rights reserved.
 */
#include <lcrash.h>

extern _command_t i386_cmdset[];

int
arch_init(FILE *ofp)
{
	return(register_cmds(i386_cmdset));
}

/* Architecture specific print routines. This allows commands to print out
 * arch dependant values such as kernel addresses, from within the arch
 * independant section of lcrash. 
 */

/*
 * print_kaddr()
 *
 * Print out a kernel address. Note that there leading "0x".
 */
void
print_kaddr(kaddr_t kaddr, FILE *ofp, int flag)
{
	if (flag == 1) {
		fprintf(ofp, "%#10x", kaddr);
	} else if (flag == 2) {
		fprintf(ofp, "%#010x", kaddr);
	} else {
		fprintf(ofp, "%#x", kaddr);
	}
}
