/*
 * include/kl_stabs.h
 *
 * Copyright 1999 Silicon Graphics, Inc. All rights reserved.
 */

#ifndef __KL_STABS_H
#define __KL_STABS_H

/* STABS specific types
 */
#define STAB_XSTRUCT	100	/* Cross referense to STAB_STRUCT */
#define STAB_XUNION	101	/* Cross referense to STAB_UNIONB */
#define STAB_XENUM	102	/* Cross referense to STAB_ENUM */

typedef struct stab_type_s {
        kltype_t        st_klt;          /* must be first */

	/* STABS SPECIFIC FIELDS */
        int             st_bit_offset;   /* from start of struct/union */
        uint64_t 	st_type_num;     /* STAB type_num */
        uint64_t 	st_real_type;    /* real type type_num */
        uint64_t 	st_index_type;   /* type_num of array index */ 
        uint64_t 	st_element_type; /* type_num of array element */
} stab_type_t;

#define st_name st_klt.kl_name
#define st_type st_klt.kl_type                      
#define st_ptr st_klt.kl_ptr                      
#define st_flags st_klt.kl_flags
#define st_typestr st_klt.kl_typestr
#define st_size st_klt.kl_size
#define st_offset st_klt.kl_offset
#define st_low_bounds st_klt.kl_low_bounds
#define st_high_bounds st_klt.kl_high_bounds
#define st_value st_klt.kl_value
#define st_bit_size st_klt.kl_bit_size
#define st_next st_klt.kl_next
#define st_member st_klt.kl_member
#define st_realtype st_klt.kl_realtype
#define st_indextype st_klt.kl_indextype
#define st_elementtype st_klt.kl_elementtype
#define st_encoding st_klt.kl_encoding

/* Forward declarations
 */
stab_type_t *st_find_type(
	char *			/* type name */,
	uint64_t		/* type_num */);

stab_type_t *st_find_type_num(
	unsigned long long int	/* type_num */);

/* Structure allocated for every namelist. A namelist can be either an
 * object file (.o or executible), or it can be an archive (.a). 
 */
typedef struct st_nmlist_s {
	char            *sts_filename;	/* disk file name */
	short		 sts_type;	/* ST_OBJ or ST_AR */
	short		 sts_nfiles;	/* number of source/object files */
} st_nmlist_t;

/* Values for type field
 */
#define ST_OBJ	1	/* object file (.o or executible) */
#define ST_AR	2	/* archive */

/* Structure containing information about an stabs symbol entry
 */
typedef struct st_sym_s {
	btnode_t         sym_bt;	/* must be first */
	short		 sym_state;	/* current state */
	short		 sym_stabtype;	/* STABS type */
	short		 sym_flag;	/* current type flag */
	short	         sym_type;	/* symbol type */
	short         	 sym_nmlist;	/* namelist index */
	short            sym_srcfile;	/* source file index */
	short            sym_incfile;	/* include file index */
	int		 sym_num;	/* symbol number */
	int         	 sym_off;	/* symbol offset in string table */
	int         	 sym_staboff;	/* symbol table offset */
	uint64_t	 sym_typenum;	/* arbitrary type number */
	kltype_t	*sym_kltype;	/* Full type information */ 
	struct st_sym_s	*sym_next;	/* next pointer (for hashing) */
} st_sym_t;
#define sym_name sym_bt.bt_key

/* Structure for cross referencing one type number to another
 */
typedef struct st_hashrec_s {
	uint64_t         	 h_typenum;   	/* type number */
	st_sym_t		*h_ptr;		/* pointer to actual type */
	struct st_hashrec_s	*h_next; 	/* next pointer (for hashing) */
} st_hashrec_t;

#define HASH_SYM	1
#define HASH_XREF	2

/* State flags
 */
#define ST_SETUP	0x1
#define ST_SETUP_DONE	0x2
#define ST_SETUP_FAILED	0x4

/* Flags for identifying individual symbol types (necessary 
 * because N_LSYM can be both type or typedef, etc.)
 */
#define ST_SRCFILE	0x0001
#define ST_TYPE		0x0002
#define ST_TYPEDEF	0x0004
#define ST_FUNC		0x0008
#define ST_PARAM	0x0010
#define ST_LINE		0x0020
#define ST_VAR		0x0040

/* Stab entry type Flags. For determining which stab entries to 
 * capture from the symbol table.
 */
#define ST_UNDF		0x0001
#define ST_SO		0x0002
#define ST_LSYM		0x0004
#define ST_GSYM		0x0008
#define ST_PSYM		0x0010
#define ST_STSYM	0x0020
#define ST_LCSYM	0x0040
#define ST_FUN		0x0080
#define ST_BINCL	0x0100
#define ST_EINCL	0x0200
#define ST_EXCL		0x0400
#define ST_SLINE	0x0800
#define ST_XTYPE	0x1000
#define ST_RSYM         0x2000
#define ST_DEFAULT	(ST_LSYM|ST_GSYM|ST_FUN)

/* can be used with both sets of flags 
 */
#define ST_ALL		0xffff 	

#define N_UNDF 		0        

/* Structures that allow us to selectively cycle through only those BFD
 * sections containing STAB data.
 */
typedef struct stab_sect_s {
	char *stabsect_name;
	char *strsect_name;
} stab_sect_t;

#endif /* __KL_STABS_H */
