/*-*-c++-*-
 * $Id: cdumpview.h,v 1.1 2002/01/28 15:38:32 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#ifndef CDUMPVIEW_H
#define CDUMPVIEW_H

#include "osdep.h"

#ifndef WIN32
# ifndef _GNU_SOURCE
#  define _GNU_SOURCE
# endif
#endif

#include <qwidget.h>
#include <qlist.h>
#include <qmainwindow.h>

class QLcrashDoc;
class QLcrashApp;
class CDumpViewDisplay;
class CToolButton;

class QComboBox;
class QToolBar;
class QToolButton;
class QLineEdit;

/**Displays a graphical dump view
  *@author Michael Geselbracht
  */

class CDumpView : public QMainWindow {
   Q_OBJECT

public:
	CDumpView(UINT64 addr, QLcrashApp* app, QWidget *parent, const char *name=0, WFlags f=0);
	~CDumpView();
	
	// Add and display an address
	void addAddress(UINT64 addr);
	
	// enable/disable toolbars
	void enableToolbar(bool);
	
	// No size hint available (returns invalid size)
	virtual QSize sizeHint() const;
	
protected:
	virtual void resizeEvent(QResizeEvent*);
	void initToolbar();
	void createHistoryPopup();
	void updateCaption();
	bool eventFilter(QObject*, QEvent*);

protected slots:
	void slotFastUp();
	void slotSlowUp();
	void slotSlowDown();
	void slotFastDown();
	void slotAddressChanged();
	void slotStatusText(QString str, int time);
	void slotAddrPrev();
	void slotAddrNext();
	void slotAddrJump();
	void slotClose();
	void slotPrevMenu(int id);
	void slotNextMenu(int id);
	
private slots:
	void slotNavOrientationChanged(Orientation);
	
private:
	QLcrashApp* oApp;
	CDumpViewDisplay* oView;
	QLineEdit* oAddress;
	QComboBox* oDumpFormat;
	QComboBox* oDumpType;
	QComboBox* oDumpEndian;
	QToolBar* oMainbar;
	QToolBar* oNavbar;
	QToolButton* oFastUp;
	QToolButton* oSlowUp;
	QToolButton* oSlowDown;
	QToolButton* oFastDown;
	CToolButton* oAddrNext;
	CToolButton* oAddrPrev;
	QPopupMenu* oPrevMenu;
	QPopupMenu* oNextMenu;
	UINT64 oCurAddr;
	QList<QString> oPrevList;
	QList<QString> oNextList;
};

#endif
