/*-*-c++-*-
 * $Id: chotkey.h,v 1.1 2002/01/28 15:38:32 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#ifndef CHOTKEY_H
#define CHOTKEY_H

#include <qdialog.h>

// Customizable actions

typedef enum {
	HK_newConsole,
	HK_taskList,
	HK_layout,
	HK_graphPrint,
	HK_graphWalk,
	HK_graphTrace,
	HK_switchMDI,
	HK_switchMDIrev,
	HK_exit,
	HK_newDumpView,
	HK_restart,
	HK_toggleToolbar,
	HK_toggleStatusbar,
	HK_toggleTaskbar,
	HK_options,
	HK_keyBindings,
	HK_windowCascade,
	HK_windowTile,
	HK_windowLower,
	HK_helpAbout,
	HK_helpManual,
	HK_findItem,
	HK_symbolList,
	HK_symbolListUpdate
} CHotKeyType;

// Qt classes
class QListView;
class QListViewItem;
class QButtonGroup;
class QLabel;
class QRadioButton;
class QPushButton;
class QAction;
template<class T> class QIntDict;

class QLcrashApp;
class HKListViewItem;
class CAction;
class CConfigManager;

/**This class offers a hotkey managment. Keys can be added
dynamically which are then customizable by the user.
  *@author Michael Geselbracht
  */

class CHotKey : public QDialog {
   Q_OBJECT

public: 
	CHotKey(QLcrashApp* app, const char* name=0);
	~CHotKey();
	
	// get action for specified id
	QAction* action(int id);
	
	// store user specified hotkeys in config object
	void storeConfig(CConfigManager* mgr);
	void loadConfig(CConfigManager* mgr);
	
signals:
	void sigAction(int id);

protected:
	virtual void resizeEvent(QResizeEvent*);
	bool eventFilter(QObject*, QEvent*);
	
	void initListView();
	void recordingStart();
	void recordingEnd();
	void recordingBreak();
	HKListViewItem* findHotKey(int code);
	void setCustomField(CAction*);
	
protected slots:
	void slotActionChanged(QListViewItem*);
	void slotKeyClicked(int);
	void slotOk();
	void slotCancel();
	void slotAction(CAction*);
	
private:
	QLcrashApp* oApp;
	
	QListView* oActionList;
	QIntDict<CAction>* oActionMap;
	QButtonGroup* oBGroup;
	QRadioButton* oKeyNo;
	QRadioButton* oKeyDefault;
	QRadioButton* oKeyCustom;
	QLabel* oHotKey;
	QPushButton* oOk;
	QPushButton* oCancel;
	bool oRecording;
};

#endif
