/*-*-c++-*-
 * $Id: clistview.h,v 1.1 2002/01/28 15:38:32 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#ifndef CLISTVIEW_H
#define CLISTVIEW_H

#include <qwidget.h>
#include <qlistview.h>

/**A list view with an additional close signal.
  *@author Michael Geselbracht
  */

class CListView : public QListView  {
   Q_OBJECT

public: 
	CListView(QWidget *parent, const char *name=0);
	~CListView();
	
	QString rootName() const;
	QString rootValue() const;
	
	virtual QSize sizeHint() const;
	
	// Find and select item that begins with `str'
	QString findItem(const QString& str);
	
	// Display a find dialog for this list
	void findDialog();
	
	// Specify column for find dialog. -1 disables the dialog
	inline void setFindColumn(int col) {
		oFindColumn = col;
	}
	
signals:
	void sigClosed(CListView*);
	
protected:
	virtual void closeEvent(QCloseEvent*);
	virtual void keyPressEvent(QKeyEvent*);
	
private:
	int oFindColumn;
};

#endif
