/*-*-c++-*-
 * $Id: cnumberofelementsdialog.cpp,v 1.1 2002/01/28 15:38:32 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#include "cnumberofelementsdialog.h"
#include "crashtypes.h"

#include <qvalidator.h>

#include "resourceadapter.h"

CNumberOfElementsDialog::CNumberOfElementsDialog(QWidget* parent, const char* name) : QDialog(parent, name, true)
{
	setCaption(stdCaption(tr("Number of elements")));
	setIcon(Resource::getBitmap(IDR_PNG7));
	oLabel = new QLabel(tr("Number of elements") + ":", this);
	oLabel->setAutoResize(true);
	oLabel->update();
	oEdit = new QLineEdit(this);
	oEdit->resize(50, oLabel->height());
	oOk = new QPushButton(tr("Ok"), this);
	oOk->setAutoResize(true);
	oOk->setDefault(true);
	oCancel = new QPushButton(tr("Cancel"), this);
	oCancel->setAutoResize(true);
	
	connect(oEdit, SIGNAL(returnPressed()), SLOT(slotReturnPressed()));
	connect(oOk, SIGNAL(clicked()), SLOT(slotOk()));
	connect(oCancel, SIGNAL(clicked()), SLOT(slotCancel()));
	
	oEdit->setFocus();
	
	setMinimumSize(200, 10);
	setFixedHeight(60);
}

CNumberOfElementsDialog::~CNumberOfElementsDialog()
{
}

void
CNumberOfElementsDialog::resizeEvent(QResizeEvent*)
{
	oLabel->move(5, 5);
	oEdit->move(oLabel->x() + oLabel->width() + 5, oLabel->y());
	oEdit->setValidator(new QIntValidator(this));
	oCancel->move(width() - oCancel->width() - 5, 30);
	oOk->move(oCancel->x() - oOk->width() - 5, oCancel->y());
}

void
CNumberOfElementsDialog::slotOk()
{
	accept();
}

void
CNumberOfElementsDialog::slotCancel()
{
	reject();
}

void
CNumberOfElementsDialog::slotReturnPressed()
{
	accept();
}

int
CNumberOfElementsDialog::value() const
{
	int retval = oEdit->text().toInt();
	if (retval < 0) {
		retval = 0;
	}
	
	return retval;
}
