/*-*-c++-*-
 * $Id: cpreferencesdialog.h,v 1.1 2002/01/28 15:38:32 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#ifndef CPREFERENCESDIALOG_H
#define CPREFERENCESDIALOG_H

#include <qdialog.h>
#include <qfont.h>

// erveryone who use this class also need crashtypes
#include "crashtypes.h"

class QLcrashDoc;

class QPushButton;
class QFrame;
class QLabel;
class QComboBox;
class QLineEdit;
class QCheckBox;

/**
  *@author Michael Geselbracht
  */

class CPreferencesDialog : public QDialog  {
	Q_OBJECT
	
public: 
	CPreferencesDialog(QLcrashDoc* doc, QWidget* parent, const char* name=0);
	~CPreferencesDialog();
	
	/** Returns true if the user specified another font
	*/
	inline bool fontChanged() const {
		return oFontChanged;
	}
	
	/** Return the current font setting.
	*/
	inline QFont& font() {
		return oFont;
	}
	
protected:
	virtual void resizeEvent(QResizeEvent*);
	
protected slots:
	void slotOk();
	void slotCancel();
	void slotGlobalFontSelect();
	void slotFontSelect();
	void slotPathSelect();
	
private:
	void setFontLabel();
	
	QPushButton* oOk;
	QPushButton* oCancel;
	QFrame* oTop;
	QFrame* oBot;
	
	QLabel* oFontT;
	QLabel* oFontC;
	QPushButton* oFontS;
	
	QLabel* oGlobalFontT;
	QLabel* oGlobalFontC;
	QPushButton* oGlobalFontS;
	
	QLabel* oPathT;
	QLineEdit* oPathC;
	QPushButton* oPathS;
	
	QLabel* oPFormatT;
	QComboBox* oPFormatC;
	
	QCheckBox* oDumpTBOnMainB;
	
	QLcrashDoc* oDoc;
	QString oGlobalFontFamily;
	int oGlobalFontSize;
	QString oFontFamily;
	int oFontSize;
	QString oPath;
	
	bool oFontChanged;
	QFont oGlobalFont;
	QFont oFont;
};

#endif
