/*-*-c++-*-
 * $Id: csplash.cpp,v 1.1 2002/01/28 15:38:32 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#include "csplash.h"

#include <qtimer.h>
#include <qapplication.h>
#include <qpixmap.h>
#include <assert.h>

#include "crashtypes.h"

#include "resourceadapter.h"

CSplash::CSplash() : QFrame(0, "csplash",
	WStyle_Customize | WStyle_StaysOnTop | WStyle_NoBorderEx)
{
	//setFrameStyle(QFrame::Box | QFrame::Raised);
	setFrameStyle(QFrame::Panel | QFrame::Raised);
	setLineWidth(2);
	setMidLineWidth(1);
	
	oLogo = new QLabel(this);
	oLogo->setPixmap(Resource::getBitmap(IDR_PNG1));
	oLogo->setAutoResize(true);
	oLogo->update();
	//oLogo->move(5, 5);
	oLogo->move(3, 3);
	
	//setFixedSize(oLogo->size() + QSize(10, 10));
	setFixedSize(oLogo->size() + QSize(6, 6));
	
	move(QApplication::desktop()->width()/2 - width()/2, QApplication::desktop()->height()/2 - height()/2);	
	
/*	unfortunately, there is no main widget at this time
	QWidget* m = qApp->mainWidget();
	assert(m != 0);
	move((m->x() + m->width())/2 - width()/2, (m->y() + m->height())/2 - height()/2);
*/
	
	QTimer* ti = new QTimer(this);
	connect(ti, SIGNAL(timeout()), SLOT(slotTimeout()));
	ti->start(4000, true);
}

CSplash::~CSplash()
{
}

void
CSplash::slotTimeout()
{
	delete this;
}
