/*-*-c++-*-
 * $Id: ctaskbar.h,v 1.1 2002/01/28 15:38:32 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#ifndef CTASKBAR_H
#define CTASKBAR_H

#include <qframe.h>
#include <qlist.h>
#include "ctaskbutton.h"

//class CTaskButton;

/**A taskbar-like widget containing buttons for each task or opened window.
  *@author Michael Geselbracht
  */

class CTaskBar : public QFrame {
	Q_OBJECT
	
public:
	CTaskBar(QWidget* parent=0, const char* name=0);
	~CTaskBar();
	
	void addWidget(QWidget* win);
	void removeWidget(QWidget* win);
	
	// update button text according to the widget states (iconified/normal)
	void updateState();
	
	void cbActivated(QWidget*);
	
signals:
	void sigWidgetRemoved(QWidget* win);
	
protected:
	virtual void resizeEvent(QResizeEvent*);
	
	// laout all task buttons
	void layout();
	
private:
	QList<CTaskButton> oTaskList;
};

#endif
