/*-*-c++-*-
 * $Id: ctextring.h,v 1.1 2002/01/28 15:38:32 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#ifndef CTEXTRING_H
#define CTEXTRING_H

#include <qstring.h>
#include <qcolor.h>
#include "cstring.h"

/**A ring buffer containing QStrings.
  *@author Michael Geselbracht
  */

class CTextRing {
public:
	/* Create an empty ring. */
	CTextRing();
	
	/* Create a ring with size elements. */
	CTextRing(unsigned int size);
	
	~CTextRing();
	
	/* Set the ring size to size. The old ring will be deleted. */
	void setSize(unsigned int);
	
	/* Return ringsize */
	inline unsigned int size() const {
		return oRingSize;
	}
	
	/* Append a piece of text to the ring. The text may contain newline characters. */
	void append(const QString&, QColor=Qt::black, int pos=-1);
	
	/* Append a line to the ring. It must not contain newline characters. */
	void appendLine(const QString&, QColor=Qt::black);
	
	/* Add a string to the end of the last string. */
	void add(const QString&, QColor=Qt::black);
	
	/* Return the string at position pos. If the line doesn't exist, a null pointer will be returned.
		Do not delete the returned object.
	*/
	CString* line(unsigned int);
	
	/* Return the last line.
	*/
	CString* lastLine();
	
	/* Return number of lines in this object. */
	unsigned int numLines() const;
	
	/* Delete the buffer */
	void clear();
	
private:
	CString** oRing;
	int oRingSize;
	int oHead;
	int oTail;
};

#endif
