/*-*-c++-*-
 * $Id: ctoolbutton.h,v 1.1 2002/01/28 15:38:32 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#ifndef CTOOLBUTTON_H
#define CTOOLBUTTON_H

#include <qtoolbutton.h>


/**A reimplementation of the 'setPopup()' functionality of QToolButton.
It is a workaround for strange segfaults when using the QPopupMenu's 'activated()' signal.
  *@author Michael Geselbracht
  */

class CToolButton : public QToolButton {
   Q_OBJECT

public:
	CToolButton(const QPixmap& pm, const QString& textLabel, const QString& groupText, QObject* receiver, const char* slot, QToolBar* parent, const char *name=0);
	~CToolButton();
	
	void setPopup(QPopupMenu* pop);
	
signals:
	void sigActivated(int id);
	
private slots:
	void slotTimeout();
	void slotPressed();
	void slotReleased();
	
private:
	QTimer* oTimer;
	QPopupMenu* oPopup;
};

#endif
