/*-*-c++-*-
 * $Id: ctreeview.h,v 1.1 2002/01/28 15:38:32 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#ifndef CTREEVIEW_H
#define CTREEVIEW_H

#include <qwidget.h>

class CWalkNavigator;
class QListView;

/**Displays a QListView and an optional navigator widget for
the 'walk' command.
  *@author Michael Geselbracht
  */

class CTreeView : public QWidget {
   Q_OBJECT

public: 
	CTreeView(QWidget *parent, const char *name=0);
	~CTreeView();
	
	void setTree(QListView* tree);
	void showNavigator(bool w);
	QString rootName() const;
	QString rootValue() const;
	
protected:
	virtual void resizeEvent(QResizeEvent*);
	
private:
	QListView* oListView;
	CWalkNavigator* oNavigator;
};

#endif
