/*-*-c++-*-
 * $Id: cwalknavigator.cpp,v 1.1 2002/01/28 15:38:33 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#include "cwalknavigator.h"
#include "begin.xpm"
#include "left.xpm"
#include "right.xpm"
#include "end.xpm"

#include <qpushbutton.h>
#include <qlabel.h>

extern const char* close_xpm[];

CWalkNavigator::CWalkNavigator(QWidget *parent, const char *name) : QFrame(parent, name)
{
	const int size = 16;
	setFixedHeight(20);
	
	oBeginB = new QPushButton(this);
	oBeginB->setFlat(true);
	oBeginB->setPixmap(QPixmap(begin_xpm));
	oBeginB->resize(size, size);
	
	oLeftB = new QPushButton(this);
	oLeftB->setFlat(true);
	oLeftB->setPixmap(QPixmap(left_xpm));
	oLeftB->resize(size, size);
	
	oRightB = new QPushButton(this);
	oRightB->setFlat(true);
	oRightB->setPixmap(QPixmap(right_xpm));
	oRightB->resize(size, size);
	
	oEndB = new QPushButton(this);
	oEndB->setFlat(true);
	oEndB->setPixmap(QPixmap(end_xpm));
	oEndB->resize(size, size);
	
	oCloseB = new QPushButton(this);
	oCloseB->setFlat(true);
	oCloseB->setPixmap(QPixmap(close_xpm));
	oCloseB->resize(size, size);
	
	oLabel = new QLabel(this);
	
	connect(oBeginB, SIGNAL(clicked()), SIGNAL(sigBegin()));
	connect(oLeftB, SIGNAL(clicked()), SIGNAL(sigLeft()));
	connect(oRightB, SIGNAL(clicked()), SIGNAL(sigRight()));
	connect(oEndB, SIGNAL(clicked()), SIGNAL(sigEnd()));
	connect(oCloseB, SIGNAL(clicked()), SIGNAL(sigClose()));
}

CWalkNavigator::~CWalkNavigator()
{
}

void
CWalkNavigator::resizeEvent(QResizeEvent*)
{
	const int x = 5;
	const int y = 2;
	const int w = oBeginB->width();
	
	oLabel->resize(width() - 5*w - 7*x, height() - 4);
	
	oBeginB->move(0*w + 1*x, y);
	oLeftB->move(1*w + 2*x, y);
	oLabel->move(2*w + 3*x, y);
	oRightB->move(2*w + 4*x + oLabel->width(), y);
	oEndB->move(3*w + 5*x + oLabel->width(), y);
	oCloseB->move(4*w + 6*x + oLabel->width(), y);
}
