/*-*-c++-*-
 * $Id: cwalknavigator.h,v 1.1 2002/01/28 15:38:33 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#ifndef CWALKNAVIGATOR_H
#define CWALKNAVIGATOR_H

#include <qframe.h>

class QPushButton;
class QLabel;

/**
  *@author Michael Geselbracht
  */

class CWalkNavigator : public QFrame {
   Q_OBJECT

public:
	CWalkNavigator(QWidget *parent, const char *name=0);
	~CWalkNavigator();
	
signals:
	void sigBegin();
	void sigLeft();
	void sigRight();
	void sigEnd();
	void sigClose();

protected:
	virtual void resizeEvent(QResizeEvent*);

private:
	QPushButton* oBeginB;
	QPushButton* oLeftB;
	QPushButton* oRightB;
	QPushButton* oEndB;
	QPushButton* oCloseB;
	QLabel* oLabel;
};

#endif
