/*-*-c++-*-
 * $Id: localplugin.h,v 1.1 2002/01/28 15:38:33 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (Michael.Geselbracht@de.ibm.com)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#ifndef _LOCALPLUGIN_H_
#define _LOCALPLUGIN_H_

#include "generic_h.h"
#include <qcstring.h>

#include <sys/types.h>

extern "C" void CHLDhandler(int);

class DLLEXPORT QString;
class QSocketNotifier;
class QTimer;

class CLocalChild : public CChildImplementation {
	Q_OBJECT

public:
	CLocalChild();
	~CLocalChild();

	bool writeStdin(QString);

	/**
	 * Check if program exists and is a
	 * valid executable.
	 */
	bool valid();

	/** Create a child process.
	 *
	 */
	void forkChild();

	/** Check if child is running.
	 *
	 */
	bool running();

	/** Send a signal to the child
         */
	void killChild(int);

	int configure(QWidget *parent);

	cfgMap getConfigValues();

	void setConfigValues(cfgMap);

	bool configured();

	friend void CHLDhandler(int);

private slots:
	void slotTimeout();
	void slotStdoutReady(int);
	void slotStderrReady(int);
	void slotStdinReady(int);

private:
	void childDied();
	void parentIOclose();
	bool childIOsetup();
	bool parentIOsetup();

	QString outBuffer;
	QString path;
	QString argv;

	QTimer *timer;
	QValueList<pid_t> diedPids;

	int in[2];
	int out[2];
	int err[2];

	bool runs;

	pid_t pid;

	QSocketNotifier *in_sn;
	QSocketNotifier *out_sn;
	QSocketNotifier *err_sn;

};


#endif

/*
 * Local variables:
 * c-basic-offset: 8
 * End:
 */
