/*-*-c++-*-
 * $Id: qlcrash.h,v 1.1 2002/01/28 15:38:33 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#ifndef QLCRASH_H
#define QLCRASH_H

// include files for QT
#include <qapp.h>
#include <qmainwindow.h>
#include <qaction.h>
#include <qmenubar.h>
#include <qtoolbar.h>
#include <qstatusbar.h>
#include <qwhatsthis.h>
#include <qpopupmenu.h>
#include <qaccel.h>
#include <qtoolbutton.h>
#include <qmsgbox.h>
#include <qstring.h>
#include <qpixmap.h>

// forward declaration of the QLcrash classes
class QLcrashDoc;
class QLcrashView;
class CMainWin;
class CTaskBar;
class CHotKey;
class CConfigManager;

class QLcrashApp : public QMainWindow
{
  Q_OBJECT
  
  public:
    /** construtor */
    QLcrashApp(CConfigManager* cm);

    /** destructor */
    ~QLcrashApp();

    inline QLcrashDoc* document() {
    	return oDocument;
    }
    inline CMainWin* view() {
    	return oMainWin;
    }

    void showToolbar(QToolBar*, bool main);
    void hideToolbar(QToolBar*, bool main);

public slots:
	void slotNewChildWin(QWidget* child);
	void slotBusy(bool);
	
	/** A widget was removed from the task bar */
	void slotRemovedChildWin(QWidget* win);
	
protected:
	virtual void resizeEvent(QResizeEvent*);
	virtual bool eventFilter(QObject*, QEvent*);

protected slots:
	/** process hotkeys */
	void slotActionHandler(int id);

	/** exits application, asking if user really wants this */
	void slotExit(bool);

	/** exits the application */
	void slotFileQuit();
	
	/** show a new dump window */
	void slotFileNewDump();
	
	/** toggle the toolbar*/
	void slotViewToolBar(bool toggle);

	/** toggle the statusbar */
	void slotViewStatusBar(bool toggle);
	
	/** toggle the taskbar */
	void slotViewTaskBar(bool toggle);

	/** shows an about dlg */
	void slotHelpAbout();
	
	/** displays the help browser */
	void slotHelpManual();

    /** change the status message of the whole statusbar temporary */
    void slotStatusHelpMsg(const QString &text);

    /** display a setup dialog. */
    void slotOptions();

    /** configure key bindings */
    void slotKeyBindings();

    void slotWindowTile();
    void slotWindowCascade();

    /** activates the MDI child widget when it gets selected from the window menu. */
    void slotWindowMenuActivated( int id );

    /** layout all objects in active window. */
    void slotViewLayout();

    /** set focus to the next window */
    void slotViewNextWindow();

	/** set focus to the previous window */
    void slotViewPrevWindow();

    /** lower the current widget */
    void slotViewLowerCurrent();

    /** display/update task list */
    void slotTaskList();

    /** show a dialog for a graph print command */
	void slotGraphPrint();
	
	/** Show a dialog for a graph walk command */
	void slotGraphWalk();
	
	/** invoked if lcrash is ready to receive commands */
	void slotLCrashReady();
	
	/** Store the current toolbar status and position */
	void storeToolBars();
	
	/** Restore previous toolbar status and position */
	void restoreToolBars();
	
	/** Enable/Disable actions depending on the window type  */
	void slotWindowActivated(QWidget*);
	
	/** Return from busy state */
	void slotBusyTimeout();
	
private:

    /** initializes all QActions of the application */
    void initActions();

    /** initMenuBar creates the menu_bar and inserts the menuitems */
    void initMenuBar();

    /** this creates the toolbars. Change the toobar look and add new toolbars in this
     * function */
    void initToolBar();

    /** setup the statusbar */
    void initStatusBar();

    /** setup the mainview */
    void initView();

    /** setup the document */
	void initDocument(CConfigManager* cm);
	
	/** initialize s390dbf actions */
	void initS390dbf();

    /** file_menu contains all items of the menubar entry "File" */
    QPopupMenu* pFileMenu;

    /** edit_menu contains all items of the menubar entry "Edit" */
    QPopupMenu* pEditMenu;

    /** view_menu contains all items of the menubar entry "View" */
    QPopupMenu* pViewMenu;

    /** view_menu contains all items of the menubar entry "Help" */
    QPopupMenu* pHelpMenu;

    /** the options menu */
    QPopupMenu* pOptionMenu;

    /** the window menu */
    QPopupMenu* pWindowMenu;

    QToolBar* fileToolbar;
    QToolBar* childToolbar;

    QAction* fileS390dbf;

    CMainWin *oMainWin;

    QLcrashDoc* oDocument;

    // used for the common toolbar (dump view
    bool oToolbarInfo;
	ToolBarDock oMainbarEdge;
	ToolBarDock oNavbarEdge;
	int oMainbarIndex;
	int oNavbarIndex;
	bool oMainbarNL;
	bool oNavbarNL;
	int oMainbarOffset;
	int oNavbarOffset;
	// --<
	
	CTaskBar* oTaskBar;
	CHotKey* oAction;
	bool oBusy;
};
#endif

