%define name lkcdutils
%define version 4.1
%define release 1

Name: %{name}
Summary: Linux Kernel Crash Dump (LKCD) Utilities
Version: %{version}
Release: %{release}
Copyright: GPL
Group: Utilities/System
Source: %{name}-%{version}-%{release}.tar.gz
URL: http://oss.sgi.com/projects/lkcd/
Packager: Matt Robinson <yakker@alacritech.com>

%description
This software package contains system crash dump analyzer tools.
It includes Linux Crash (lcrash) and all appropriate user level
scripts required for saving and configuring system crash dumps.
This package should be installed after the lkcd kernel patches are
installed on the system.

%package source
Summary: The source code for %{name}-%{version}.
Group: Utilities/System

%description source
This software package includes all source code for any programs
and scripts required to support system crash dumps on a Linux
machine.

%prep
/bin/rm -r -f $RPM_BUILD_DIR/%{name}
%setup
%build
%ifarch ia64
configure
%else
%configure
%endif
make

%install
make install

%files
/sbin/lcrash
/sbin/lkcd
/sbin/lkcd_ksyms
/sbin/lkcd_config
/usr/include/lkcd/alloc.h
/usr/include/lkcd/asm/dump.h
/usr/include/lkcd/asm/kl_arch.h
/usr/include/lkcd/asm/kl_cmp.h
/usr/include/lkcd/asm/kl_mem.h
/usr/include/lkcd/asm/kl_types.h
/usr/include/lkcd/asm/lc_extern.h
/usr/include/lkcd/asm/lc_report.h
/usr/include/lkcd/asm/lc_trace.h
/usr/include/lkcd/asm/vmdump.h
/usr/include/lkcd/dump.h
/usr/include/lkcd/kl_alloc.h
/usr/include/lkcd/kl_btnode.h
/usr/include/lkcd/kl_error.h
/usr/include/lkcd/kl_htnode.h
/usr/include/lkcd/kl_lib.h
/usr/include/lkcd/kl_libutil.h
/usr/include/lkcd/kl_mem.h
/usr/include/lkcd/kl_queue.h
/usr/include/lkcd/kl_stabs.h
/usr/include/lkcd/kl_stringtab.h
/usr/include/lkcd/kl_sym.h
/usr/include/lkcd/kl_task.h
/usr/include/lkcd/kl_typeinfo.h
/usr/include/lkcd/klib.h
/usr/include/lkcd/lc_command.h
/usr/include/lkcd/lc_eval.h
/usr/include/lkcd/lcrash.h
/usr/include/lkcd/rl.h
/usr/include/lkcd/vmdump.h
/usr/include/lkcd/zlib.h
/usr/lib/lkcd/libklib.a
/usr/lib/lkcd/liblkcd_rl.a
/usr/lib/lkcd/liblkcd_util.a
/usr/lib/lkcd/liblkcd_alloc.a
/usr/man/man1/lcrash.1
/usr/man/man1/lkcd_ksyms.1
/usr/man/man1/lkcd_config.1
/etc/sysconfig/dump
%ifarch i386 i586 i686
/usr/share/sial/lcrash
/usr/lib/libsial.a
/usr/include/sial_api.h
/usr/include/lkcd/asm/lc_dis.h
%endif
