/************************************************************
 *
 * COPYRIGHT (C) HITACHI,LTD. 2005
 * WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY.
 *
 * Created by M. Hiramatsu <hiramatu@sdl.hitachi.co.jp>
 * 
 * noop handler
 *
 ************************************************************/

#include <linux/version.h>
#include <linux/init.h>
#include <linux/module.h>
#include <linux/moduleparam.h>
#include <linux/lkst_private.h>

static int  lkst_mod_init(void);
static void lkst_mod_cleanup(void);
static void lkst_evhandler_noop(void *phookrec, int event_type,
				lkst_arg_t arg1, lkst_arg_t arg2,
				lkst_arg_t arg3, lkst_arg_t arg4);

static LKST_EH_DEV_DEF(LOG_NOOP,lkst_evhandler_noop,
		       NULL,NULL,NULL);

module_init(lkst_mod_init);
module_exit(lkst_mod_cleanup);

MODULE_AUTHOR("M. Hiramatsu <hiramatu@sdl.hitachi.co.jp>");
MODULE_DESCRIPTION("LKST module noop event handler.");
MODULE_LICENSE("GPL");

int evhandler_id = LKST_EVHANDLER_ID_VOID;
MODULE_PARM(evhandler_id, "i");
MODULE_PARM_DESC(evhandler_id, "id of event-hanlder to regist.");

static void lkst_evhandler_noop(void *phookrec, int event_type,
				       lkst_arg_t arg1, lkst_arg_t arg2,
				       lkst_arg_t arg3, lkst_arg_t arg4)
{
	/* nothing to do */
	return;
}

static int lkst_mod_init()
{
	int	retval;

	LKST_EH_DEV(LOG_NOOP).id = evhandler_id;
	/* Register an event handler for light logging. */
	retval = lkst_eh_device_register(&LKST_EH_DEV(LOG_NOOP));
	if (retval < 0) {
		printk(KERN_ERR "cannot register event-handler function!\n");
		return retval;
	}

	return 0;
}

static void lkst_mod_cleanup()
{
	/* deregister the event handler. */
	lkst_eh_device_unregister(&LKST_EH_DEV(LOG_NOOP));
	return;
}

