/************************************************************
 *
 * COPYRIGHT (C) HITACHI,LTD. 2003
 * WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 *            HITACHI CENTRAL RESEARCH LABORATORY.
 *
 * Created by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
 *
 ************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include "ktask.h"

void usage(void)
{
	printf("usage: taskdump [-n tracenum] [-p target_pid] [-s symfile] -f file\n");
	exit(1);
}

#define SYMSMAX 18000

struct nminfo {
	unsigned int addr;
	char * name;
};
char *symbuf;
struct nminfo syms[SYMSMAX];
int nsyms=0;
char task[8192]={0};

int opensyms(const char *sname)
{
	int fd;
	int i;
	char *pt,*ep, buf[16]="0x00000000";
	struct stat fst;
	fd = open(sname, O_RDONLY);
	if(fd < 0)return -1;
	fstat(fd, &fst);
	symbuf = (char*)malloc(fst.st_size+1);
	read(fd, symbuf, fst.st_size);
	symbuf[fst.st_size]='\0';
	ep = symbuf+fst.st_size;
	pt = symbuf;
	for (i = 0; (i < SYMSMAX) && (ep - pt > 0); i++) {
		strncpy(buf+2,pt,8);
		syms[i].addr = (unsigned)strtoll(buf, NULL, 16);
		syms[i].name = (pt+=9);
		for(;*pt != '\0' && *pt!='\n';pt++);
		if (*pt == '\0') {i++ ; break;}
		*pt = '\0';
		pt ++;
	}
	nsyms = i;
	printf("read syms = %d\n",nsyms);
	return 0;
}

int main (int argc, char *argv[])
{
	int fd,i,j,k;
	int target = -1, num=10;
	char fname[128]={0};
	unsigned long base=0;

	do {
		switch( i = getopt(argc, argv, "p:f:s:n:") ) {
		case 'p':
			target = strtol(optarg,NULL,0);
			break;
		case 'f':
			strncpy(fname,optarg,127);
			break;
		case 's':
			if (opensyms(optarg) < 0) usage();
			break;	
		case 'n':
			num = strtol(optarg,NULL,0);
			break;
		case ':':
		case '?':
			usage ();
		}
	} while (i != -1);
	if (!fname[0])
		usage();
	
	fd = open(fname, O_RDONLY);
	if( fd <0)
		return 1;

	base = 0; //TODO
	for ( i =0; i<219; i++, base = (unsigned long)kt_next(task)){
		lseek(fd, 8192*i, SEEK_SET);
		read(fd,task,8192);
		if (target != -1 && target != kt_pid(task) ) continue;
		printf("%d: CPU:%d, PID:%d, stat:%ld Stack:%p/0x%lx, %.16s\n",
		       i, kt_cpu(task),kt_pid(task), kt_state(task), 
		       kt_stack(task),(unsigned long)kt_stack(task)-base,
		       kt_name(task));
		for(k = 0; k != num; num>0?k++:k--) {
			int fn;
			unsigned long offs;
			unsigned st;
			offs = (unsigned long)kt_stack(task)-base+k*sizeof(int*);
			if (1024 > offs || 8192 < offs ) break;
			
			st = *((unsigned *)&task[offs]);
			fn = -1;
			printf ("0x%08x ", st);
			if (st >= 0xc0000000){
				for(j=0;j<nsyms;j++) 
					if ((long long)syms[j].addr - 
					    (long long)st > 0 ){
						fn =j-1; 
						break;
					}
			}
			if( fn != -1 ) {
				printf("%s(0x%08x)\n", syms[fn].name, 
				       syms[fn].addr );
			}else 
				printf("\n");
		}
	}
	close(fd);
		
	return 0;
	
}
