/*
 cleanup_mem -- cleanup caches
 
 Copyright (C) HITACHI,LTD. 2005
 WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 Created by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
 Updated by H.Kawai <h-kawai@sdl.hitachi.co.jp>
  
 The development of this program is partly supported by IPA
 (Information-Technology Promotion Agency, Japan).

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

#include <stdlib.h>
#include <stdio.h>
#include <asm/page.h>
#include <errno.h>

#ifdef __x86_64__
# define BLOCK_MAX (400*1024*1024-1)
#else // if i386
# define BLOCK_MAX (2*1024-1)
#endif


int main(int argc, char *argv[])
{
	unsigned long i;
	char *ptr;
	size_t size;
	
	if (argc!=2) {
		printf("usage: cleanup_mem MB-size\n");
		return 1;
	}
	
	size = strtoul(argv[1], NULL, 0);
	
	if (size > BLOCK_MAX)
		size = BLOCK_MAX;
	size *= 1024 * 1024;
	ptr = (char *)malloc(size);
	if (!ptr) {
		printf("Error: failed to allocate memory\n");
		return ENOMEM;
	}

	for (i = 0; i < size; i += PAGE_SIZE)
		ptr[i]=0;
	free(ptr);

	return 0;
}
