.TH LKSTLA "8" "Sep 2005" "lkstla 1.2.0" "LKST Commands"
.SH NAME
lkstla \- LKST event log analyzer
.br
.SH SYNOPSIS
lkstla \fI<analyzer>\fR [ \fIformat\fR ] [ \fIoption(s)\fR ] logfile [...]
.SH DESCRIPTION
lkstla analyze variable events traced by LKST. 
.SH ANALYZERS
.TP
\fBbdevtime
.br
Analyze block device processing time
.TP
\fBbioqueue
.br
Analyze BIO proc-time per queue-len
.TP
\fBbiotime \fR[\fB \-B \fR]
.br
Analyze BIO processing time.
.br
\fB-B\fR : Show BIO addr instead of kdevice.
.TP
\fBbiomake
.br
Analyze bio merging time.
.TP
\fBblkqueue
.br
Analyze the length of request queue in block layer.
.TP
\fBbuffer\ 
.br
Analyze buffer-head I/O time
.TP
\fBbusywait \fR[\fB \-S \fIksyms \fR]
.br
Analyze spinlock lock-contention time.
.br
\fB-S\fR : Specify kernel symbol file (default: \fI/proc/kallsyms\fR )
.TP
\fBelvqueue
.br
Analyze elevator proc-time per queue-len.
.TP
\fBelvtime \fR[\fB \-B \fR]
.br
Analyze elevator processing time.
.br
\fB-B\fR : Show BIO addr instead of kdevice.
.TP
\fBexception \fR[\fB \-S \fIksyms \fR]
.br
Analyze exception processing time.
.br
\fB-S\fR : Specify kernel symbol file (default: \fI/proc/kallsyms\fR )
.TP
\fBevent  \fR[\fB \-E \fIetypes_list\fR ]
.br
Analyze logged events.
.br
\fB-E\fR : Specify etypes list (optional)
.TP
\fBiosector \fR[ \fB-D \fR| \fB-S \fR]
.br
Analyze IO sector.
.br
\fB-D\fR : Show difference of requested sectors
.br
\fB-S\fR : Show size of requested sectors 

.TP
\fBipc \fR[ \fB-T \fR]
.br
Analyze IPC-related system call processing time:
semop, semget, semctl, msgsnd,
msgrcv, msgget, msgctl, shmat, shmdt, shmget and shmctl.
.B ipc
analyzer is only available on i386 architecture.
.br
.B \-T
: show system time instead of real time

.TP
\fBnetroute
.br
Analyze network-routing processing time.
.TP
\fBnetsend
.br
Analyze packet send delay time.
.TP
\fBpalloc
.br
Analyze page allocation processing time.
.TP
\fBproclive \fR[ \fB-P \fR]
.br
Analyze process living time
.br
\fB-P\fR : show PID instead of task_name.

.TP
\fBprocrun \fR[ \fB-P \fR]
.br
Analyze process run time
.br
\fB-P \fR: show PID instead of task_name

.TP
\fBprocstat \fR[ \fB-P \fR| \fB-L \fR]
.br
Analyze process status transition
.br
\fB-P\fR : show PID instead of task_name.
.br
\fB-L\fR : list task states
.TP
\fBrunqueue
.br
Analyze the length of runqueue.
.TP
\fBschedrun
.br
Analyze scheduling time by runqueue length.
.TP
\fBschedule \fR[ \fB-P \fR]
.br
Analyze scheduling time by process.
.br
\fB-P\fR : show PID instead of task_name.

.TP
\fBsocketcall \fR[ \fB-T \fR]
.br
Analyze socket-related system call processing time:
socket, bind, connect, listen, accept, getsockname, getpeername,
socketpair, send, recv, sendto, recvfrom, shutdown, setsockopt,
getsockopt, sendmsg and recvmsg.
.B socketcall
analyzer is only available on i386 architecture.
.br
.B \-T
: show system time instead of real time

.TP
\fBsoftirq
.br
Analyze software-irq delay-time.
.TP
\fBspinlock \fR[ \fB-S\fR \fIksyms\fR ] [ \fB-L \fR]
.br
Analyze spinlock locking time.
.br
\fB-S\fR : Specify kernel symbol file (default: \fI/proc/kallsyms\fR )
.br
\fB-L\fR : show Spinlock instead of call_address
.TP
\fBsyscall \fR[ \fB-T \fR]
.br
Analyze system call processing time.
.br
\fB-T\fR : show system time instead of real time

.TP
\fBsysinfo -A\fR < \fIarg_index\fR | \fIarg_desc\fR > [ \fB-E \fIetypes_list\fR ]
.br
Analyze system information.
.RS
.PD 0
.TP 3
.B \-A
: Specify an argument of system information event record to display.
You can specify it by ether an index of arguments \fIarg_index\fR or
description \fIarg_desc\fR. \fIarg_index\fR ranges 1 to 8.
.TP 3
.B \-E
: Specify etypes list.
.PD
.RE

.TP
\fBtimer \fR[ \fB-S\fR \fIksyms\fR ]
.br
Analyze timer-handler execution delay-time.
.br
\fB-S\fR : Specify kernel symbol file (default: \fI/proc/kallsyms\fR )

.TP
\fBvminfo -A\fR < \fIarg_index\fR | \fIarg_desc\fR > [ \fB-E \fIetypes_list\fR ]
.br
Analyze vm information.
.RS
.PD 0
.TP 3
.B \-A
: Specify an argument of vm information event record to display.
You can specify it by ether an index of arguments \fIarg_index\fR or
description \fIarg_desc\fR. \fIarg_index\fR ranges 1 to 6.
.TP 3
.B \-E
: Specify etypes list.
.PD
.RE

.TP
\fBvmscan 
.br
Analyze page reclaiming time.

.TP
\fBwaitcpu \fR[ \fB-P \fR]
.br
Analyze waiting time for run on CPU.
.br
\fB-P\fR : show PID instead of task_name.

.TP
\fBwaitqueue \fR[ \fB-S\fR \fIksyms\fR ]
.br
Analyze the length of waitqueue.
.br
\fB-S\fR : Specify kernel symbol file (default: \fI/proc/kallsyms\fR )

.TP
\fBwaittime \fR[ \fB-S\fR \fIksyms\fR ]
.br
Analyze wait-queue waiting time.
.br
\fB-S\fR : Specify kernel symbol file (default: \fI/proc/kallsyms\fR )

.SH FORMATS
.TP 1i
.B \ \ \ \ \ \ \-l\fR[\fBP\fR][\fBC\fR][\fBE\fR][\fBN\fR][\fIbase-time\fR]
Show results as log format. (DEFAULT Format)
.br
If you add "\fBP\fR", show pid. If you add "\fBN\fR" and pass logfiles
written by procname event handler, show process names.
If you add "\fBC\fR", use a
comma as delimiter instead of white spaces.
If you add "\fBE\fR", show elapsed time from the first event time
in logs instead of absolute time.
\fIbase-time\fR indicates event-time offset. This is exclusive of "\fBE\fR".

.TP 1i
.B \ \ \ \ \ \ \-s\fR[\fBC\fR]
Show results as statistics.
.br
If you add "\fBC\fR", use a comma as delimiter instead of white spaces.
.TP 1i
.B \ \ \ \ \ \ \-d[[\fImin\fR]:[\fImax\fR]:[\fIrank\fR]:[\fBL\fR][\fBC\fR]]
Show results as distributions.
.br

.SH OPTIONS
.TP 1i
.B \ \ \ \ \ \ \-h
Show help message.

.TP 1i
.B \ \ \ \ \ \ \-q
Do not print header.

.TP 1i
.B \ \ \ \ \ \ \-c\fR<[\fB!\fR]\fIcpu\fR[+\fIspan\fR|:\fIend-cpu\fR][,...]> 
Specify CPU-id filter configuration. Without "\fB!\fR" prefix, the events those
CPU-ids are included within the range from \fIcpu\fR to \fIcpu\fR+\fIspan\fR, or
to \fIend-cpu\fR are passed. With "\fB!\fR" prefix, rejected.
.TP 1i
.B \ \ \ \ \ \ \-k\fR<[\fB!\fR]\fIkey\fR[+\fIspan\fR|:\fIend-key\fR][,...]> 
Specify infokey filter configuration. Without "\fB!\fR" prefix, the events those
infokeys are included within the range from \fIkey\fR to \fIkey\fR+\fIspan\fR, or
to \fIend-key\fR are passed. With "\fB!\fR" prefix, rejected.
.TP 1i
.B \ \ \ \ \ \ \-p\fR<[\fB!\fR]\fIpid\fR[+\fIspan\fR|:\fIend-pid\fR][,...]> 
Specify PID filter configuration. Without "\fB!\fR" prefix, the events those
PIDs are included within the range from \fIpid\fR to \fIpid\fR+\fIspan\fR, or
to \fIend-pid\fR are passed. With "\fB!\fR" prefix, rejected.
.TP 1i
.B \ \ \ \ \ \ \-t\fR<[\fB!\fR]\fIstart-time\fR[+\fIspan\fR|:\fIend-time\fR][,...]> 
Specify time filter configuration. Without "\fB!\fR" prefix, the events those
rose times are included within the range from \fIstart-time\fR to \fIstart-time\fR+\fIspan\fR, or
to \fIend-time\fR are passed. With "\fB!\fR" prefix, rejected.
.TP 1i
.B \ \ \ \ \ \ \-m\fR<[\fB!\fR]\fIstart-metric\fR[+\fIspan\fR|:\fIend-metric\fR][,...]> 
Specify metric filter configuration. Without "\fB!\fR" prefix, the events those
metrics are included within the range from \fIstart-metric\fR to
\fIstart-metric\fR+\fIspan\fR, or
to \fIend-metric\fR are passed. With "\fB!\fR" prefix, rejected.

.SH RETURN VALUE
.TP
.B 0
success
.TP
.B Except 0
failure
.SH AUTHOR
Masami Hiramatsu <hiramatu@sdl.hitachi.co.jp>
.br
Hidehiro Kawai <h-kawai@sdl.hitachi.co.jp>
.SH "REPORTING BUGS"
Report bugs to <lkst-users@lists.sourceforge.net>.
.SH COPYRIGHT
Copyright \(co 2005 Hitachi, Ltd., Systems Development Laboratory
