#!/bin/sh 
# A script to apply patches of Lkstlogtools
# COPYRIGHT (C) HITACHI,LTD. 2004,2005
# Written by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
# Usage: enpatch.sh <target (kernel source) directory> [patch directory]
# Example) ./enpatch.sh /usr/src/linux-xxx ../patches

SCRDIR=`dirname $0`
[ "$SCRDIR" ] || SCRDIR=`pwd`
#source $SCRDIR/../lkst.version
#source $SCRDIR/functions

TARGET=$1
PATDIR=$SCRDIR/../patches

function usage() {
    echo "Usage: enpatch-llt.sh <target (kernel source) directory>"
    echo "      Example) ./enpatch-llt.sh /usr/src/linux-xxx "
}
if [ ! -d "$TARGET" ] ;then
    echo "Error: Target directory is not found: "$TARGET
    usage
    exit 0
fi
LOGFILE=$TARGET/lkst-patch.log

function kpatch () {
    echo  Apply $1 Patch >> $LOGFILE
    patch -d $TARGET -p1 < $1 >> $LOGFILE
}

kpatch $PATDIR/hook-softirq.patch
kpatch $PATDIR/hook-timer.patch
kpatch $PATDIR/hook-mem.patch
kpatch $PATDIR/hook-bio.patch
kpatch $PATDIR/hook-spinlock.patch
kpatch $PATDIR/hook-sched.patch
kpatch $PATDIR/hook-net.patch
kpatch $PATDIR/hook-proc.patch
kpatch $PATDIR/hook-elv.patch
kpatch $PATDIR/export-stat.patch
echo "done. Logs are written in " $LOGFILE "."
