#!/bin/sh
# Copyright (C) HITACHI,LTD. 2005
# WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
# Created by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
# Updated by H.Kawai <h-kawai@sdl.hitachi.co.jp>

ARCH=`uname -m`

. ../.config

case $ARCH in 
	i?86)
	ARCH=-i386 ;;
	*)
	ARCH=-$ARCH
esac
if [ -f $KSRCDIR/include/asm/unistd.h ]; then
	ARCH=
fi

#OUTFILE=../include/syscalls.h
NRSYS=0

write_entry () {
    SYSCALL=`echo $2 | sed s/__NR_//g`
    SYSCALLNO=$3
    if echo $SYSCALLNO | grep ^[0-9] > /dev/null ; then
	echo \[$SYSCALLNO\] = \"$SYSCALL\" \,
	    [ $NRSYS -lt $SYSCALLNO ] && NRSYS=$SYSCALLNO
    fi
    return -1
}

write_entries () {
    echo "/* This is Generated by mksyscalls.sh - for linux-$KVER on $ARCH */"
    echo "#include <sys/syscall.h>"
    # hack for ipc and socketcall analyzer
    # FIXME: remove this hack code
    echo "#ifndef _WITHOUT_SYSCALL_NAME_DEFINITION_"
    echo "char * syscall_name[] = {"
    while true; do
	read aline
	[ -z "$aline" ] && break;
	write_entry $aline
    done
    echo "};"
    echo "#endif"
    echo "#define NR_syscalls " `expr $NRSYS + 1 `
    echo "extern char *syscall_name[NR_syscalls];"
}

TMPF=`mktemp /tmp/tmp$$.XXXXXX` 
grep "^#define __NR_" $KSRCDIR/include/asm$ARCH/unistd.h > $TMPF

write_entries < $TMPF
rm $TMPF
 
