/*
 elv processing time analyzer

 Copyright (C) HITACHI,LTD. 2005
 WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 Created by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
 Updated by H.Kawai <h-kawai@sdl.hitachi.co.jp>

 The development of this program is partly supported by IPA
 (Information-Technology Promotion Agency, Japan).
  
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

#include <stdio.h>
#include <errno.h>
#include <linux/lkst.h>
#include <linux/lkst_buffer.h>
#include <lkstla.h>

static slot_hkey info_key_elvtime(struct lkst_log_record *rec_start, struct lkst_log_record *rec_end);
static slot_hkey session_key_elvtime(struct lkst_log_record *rec);
static char * get_alias_elvtime(slot_hkey key);
static ga_type_t get_type_elvtime(struct lkst_log_record *);

static int bio_key=0;
extern struct gate_analyzer elvtime_analyzer;

static int extra_opt_handler_bio(int c, char*v) {
	bio_key = 1;
	SET_COL(elvtime_analyzer, COL_ALIAS, "bio-addr", ADDR_LEN, "%*s");

	return 0;
}

static struct command_option bio_option = {
	.opt = "B",
	.format = "-B",
	.description = "show BIO addr instead of kdevice",
	.handler = extra_opt_handler_bio,
};

struct gate_analyzer elvtime_analyzer = {
	.name = "elvtime",
	.description = "elevator processing time analyzer",
	.cols = {
		[COL_KEY] = { "address", ADDR_LEN, "%0*lx" },
		[COL_ALIAS] = { "req-queue", MAX(ADDR_LEN, 9), "%*s" },
		[COL_METRIC] = { "iosched-time" },
	},

	GA_INIT_SESSION_ANALYZER
	GA_INIT_1TON_SESSION
	GA_INIT_RET_SESSION_TIME
	GA_INIT_RET_EVENT_PID

	.info_key = info_key_elvtime,
	.session_key = session_key_elvtime,
	.get_alias = get_alias_elvtime,

	.get_type = get_type_elvtime,

	.init = init_none,
	.nr_options = 1,
	.options = {&bio_option},
};

static slot_hkey info_key_elvtime(struct lkst_log_record *rec_start,
				  struct lkst_log_record *rec_end)
{
	return (bio_key)? ARG1UL(rec_start): ARG3UL(rec_start);
}

static slot_hkey session_key_elvtime(struct lkst_log_record *rec)
{
	if (rec->posix.log_event_type == LKST_ETYPE_BLK_PUT_REQ)
		return ARG4UL(rec);
	else
		return ARG2UL(rec);
}

static char buf[256];

static char * get_alias_elvtime(slot_hkey key)
{
	sprintf(buf,"%0*lx", ADDR_LEN, key);
	return buf;
}

static ga_type_t get_type_elvtime(struct lkst_log_record *rec)
{
	//TODO:error processing
	switch(rec->posix.log_event_type){
	case LKST_ETYPE_BIO_MAKE_REQ2:
		return GAT_START;
	case LKST_ETYPE_ELV_NEXT_REQ:
		return GAT_END;
	case LKST_ETYPE_BLK_PUT_REQ:
		return GAT_REMOVE;
	default:
		return GAT_IGNORE;
	}
}

