/*
 LKST events description loader

 Copyright (C) HITACHI,LTD. 2003-2004
 WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 Created by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
  
 The development of this program is partly supported by IPA
 (Information-Technology Promotion Agency, Japan).

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

#include "eventdesc.h"

#define LKST_ETYPE_DEF(event_type, hooktype, _mnemonic, event_name, arg_1, arg_2, arg_3, arg_4)    \
	[event_type] = { .mnemonic = #_mnemonic, .name = event_name, \
			 .args = {arg_1, arg_2, arg_3, arg_4 }, \
			 .flags = LKST_EDF_##hooktype },

struct lkst_etype_description lkst_etype_desc[LKST_ETYPE_VOID+1] = {
#include <linux/lkst_etype.h>
[LKST_ETYPE_VOID] = { .mnemonic="LKST_ETYPE_VOID", .name="void event", \
                      .flags = 0 }
};
#undef LKST_ETYPE_DEF

#include <limits.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <lkstla.h>

#define BUF_SIZE 512

static char etypes_path[PATH_MAX]="";

static int extra_opt_handler_edesc(int c, char*v) 
{
	if (c == 'E') {
		if (v)	strncpy(etypes_path,v,PATH_MAX-1);
		return 0;
	}
	return -1;
}
struct command_option edesc_option = {
	.opt = "E:",
	.format = "-E etypes_list",
	.description = "specify etypes list (optional)",
	.handler = extra_opt_handler_edesc,
};

int init_eventdesc(void)
{
	if (etypes_path[0]!='\0')
		return lkst_etype_desc_load(etypes_path);
	else 
		return 0;
}

static char *csv_copy(const char* ptr, char *buf, char** nptr)
{
	char * ret = buf;
	int quoted;

	if (ptr == NULL) return NULL;

	while (isspace(*ptr)) ptr++; /*isspace() includes '\n'*/
	quoted = 0;
	while (*ptr!='\0' && *ptr!='\n') {
		if (*ptr == '\\' ) {
			ptr++;
			if ( *ptr=='\0' ) break;
		} else {
			if ( *ptr=='\"') {
				quoted = !quoted;
				ptr++;
				continue;
			}
			if ((!quoted) && *ptr==',' ) {
				ptr++;
				break;
			}
		}
		*buf++ = *ptr++;
	}
	*buf = '\0';
	if (nptr) *nptr = (char*)ptr;
	return ret;
}

static void lkst_etype_desc_free(int etype) 
{
	int i;
	if ( !(lkst_etype_desc[etype].flags & LKST_EDF_LOADED) ) return ;
	if (lkst_etype_desc[etype].mnemonic!=NULL) {
		free(lkst_etype_desc[etype].mnemonic);
		lkst_etype_desc[etype].mnemonic = NULL;
	}
	if (lkst_etype_desc[etype].name!=NULL) {
		free(lkst_etype_desc[etype].name);
		lkst_etype_desc[etype].name = NULL;
	}
	for ( i = 0; i < 4; i++)
		if (lkst_etype_desc[etype].args[i]!=NULL) {
			free(lkst_etype_desc[etype].args[i]);
			lkst_etype_desc[etype].args[i]=NULL;
		}
	lkst_etype_desc[etype].flags = 0;
}


int lkst_etype_desc_load(char * fname) 
{
	FILE *fp;
	char buf[BUF_SIZE], buf2[BUF_SIZE], *ptr;
	int etype;
	int i;
	fp = fopen(fname, "r");
	if (fp==NULL) return -1;
	while (fgets(buf, BUF_SIZE, fp) != NULL ) {
		ptr = buf;
		if ( csv_copy(ptr, buf2, &ptr) == NULL ) continue;
		etype = strtol(buf2, NULL, 0);
		if ( etype <= 0 || etype >= LKST_ETYPE_MAX ) continue;
		lkst_etype_desc_free(etype);

		if ( csv_copy(ptr, buf2, &ptr) == NULL ) continue;
		if ( buf2[0]!='\0') 
			lkst_etype_desc[etype].mnemonic = strdup(buf2);
		if ( csv_copy(ptr, buf2, &ptr) == NULL ) goto loaded;
		if ( buf2[0]!='\0') 
			lkst_etype_desc[etype].flags = strtol(buf2, NULL, 0);
		if ( csv_copy(ptr, buf2, &ptr) == NULL ) goto loaded;
		if ( buf2[0]!='\0') lkst_etype_desc[etype].name = strdup(buf2);
		for ( i = 0; i < 4; i++) {
			if ( csv_copy(ptr, buf2, &ptr) == NULL ) break;
			if ( buf2[0]!='\0')
				lkst_etype_desc[etype].args[i] = strdup(buf2);
		}
loaded:
		lkst_etype_desc[etype].flags |= LKST_EDF_LOADED;
	}
	return 0;
}

void lkst_etype_desc_free_all(void) 
{ 
	int i;
	for (i=0;i<LKST_ETYPE_VOID+1;i++)
		lkst_etype_desc_free(i);
}
