/*
 LKST block request-queue analyzer

 Copyright (C) HITACHI,LTD. 2005
 WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 Created by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
 Updated by H.Kawai <h-kawai@sdl.hitachi.co.jp>
  
 The development of this program is partly supported by IPA
 (Information-Technology Promotion Agency, Japan).

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <limits.h>
#include <linux/lkst.h>
#include <linux/lkst_buffer.h>
#include <lkstla.h>
#include <eventdesc.h>

static slot_hkey info_key_iosector(struct lkst_log_record *rec_start, struct lkst_log_record *rec_end);
static char * get_alias_iosector(slot_hkey key);
static ga_type_t get_type_iosector(struct lkst_log_record *rec);
static double get_metric_iosector_len(struct lkst_log_record *rec_start,
				     struct lkst_log_record *rec_end);

static int diff_show=0;
static int extra_opt_handler_diff(int c, char*v) {
	diff_show = 1;
	return 0;
}
static int size_show=0;
static int extra_opt_handler_size(int c, char*v) {
	size_show = 1;
	return 0;
}

static struct command_option diff_option = {
	.opt = "D",
	.format = "-D",
	.description = "show difference of requested sectors",
	.handler = extra_opt_handler_diff,
};
static struct command_option size_option = {
	.opt = "S",
	.format = "-S",
	.description = "show size of requested sectors",
	.handler = extra_opt_handler_size,
};

struct gate_analyzer iosector_analyzer = {
	.name = "iosector",
	.description = "IO sector analyzer",
	.cols = {
		[COL_KEY] = { "rq-addr", ADDR_LEN, "%0*lx" },
		[COL_ALIAS] = { "requestqueue", MAX(ADDR_LEN, 12), "%*s" },
		[COL_METRIC] = { "iosector" },
	},

	GA_INIT_EVENT_ANALYZER
	GA_INIT_DEF_LONG
	GA_INIT_RET_EVENT_PID
	GA_INIT_RET_EVENT_TIME

	.info_key = info_key_iosector,
	.get_alias = get_alias_iosector,

	.get_type = get_type_iosector,
	.get_metric = get_metric_iosector_len,

	.init = init_none,
	.nr_options = 2,
	.options = {&diff_option,&size_option}
};

static unsigned long long prev_sector = 0;
static void * prev_req = NULL;

static slot_hkey info_key_iosector(struct lkst_log_record *rec_start,
				   struct lkst_log_record *rec_end)
{
	return ARG1UL(rec_start);
}

static char buf[256];

static char * get_alias_iosector(slot_hkey key)
{
	sprintf(buf,"%0*lx", ADDR_LEN, key);
	return buf;
}

static ga_type_t get_type_iosector(struct lkst_log_record *rec)
{
	void *req = (void *)ARG2UL(rec);
	switch (rec->posix.log_event_type) {
	case LKST_ETYPE_ELV_NEXT_REQ:
		if (req == prev_req) break;
		prev_req = req;
		return GAT_EVENT;
	default:
		;
	}
	return GAT_IGNORE;
}

static double get_metric_iosector_len(struct lkst_log_record *rec_start,
				     struct lkst_log_record *rec_end)
{
	double ret;
	if (diff_show) {
		if ( prev_sector == 0) {
			ret = 0; 
		} else {
			ret = (double)(rec_start->log_arg3) - 
				(double)(prev_sector);
		}
		prev_sector = rec_start->log_arg3 + ARG4UL(rec_start);
	}else if (size_show) {
		ret = (double)ARG4UL(rec_start);
	}else {
		ret = (double)(rec_start->log_arg3);
	}
	return ret;
}
