/*
 kernel symbol reader

 Copyright (C) HITACHI,LTD. 2004-2005
 WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 Created by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
  
 The development of this program is partly supported by IPA
 (Information-Technology Promotion Agency, Japan).

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

#include <stdio.h>
#include <errno.h>
#include <limits.h>
#include <string.h>
#include <linux/lkst.h>
#include <linux/lkst_buffer.h>
#include <slot.h>
#include <ksymbols.h>

static char ksyms_path[PATH_MAX]="/proc/kallsyms";

static generic_slots_t *gsl_sym=NULL;

static int extra_opt_handler_ksymbols(int c, char*v);

struct command_option ksym_option = {
	.opt = "S:",
	.format = "-S ksyms",
	.description = "specify ksyms file(default:/proc/kallsyms)",
	.handler = extra_opt_handler_ksymbols,
};

static int extra_opt_handler_ksymbols(int c, char*v) 
{
	if (c == 'S') {
		if (v)	strncpy(ksyms_path,v,PATH_MAX-1);
		return 0;
	}
	return -1;
}

int init_ksymbols(void)
{
	return load_symbol(ksyms_path);
}

void cleanup_symbol(void) 
{
	free_generic_slots(gsl_sym);
	gsl_sym = NULL;
}

int load_symbol(const char *fname)
{
	FILE *fp;
	char buf[BUFSIZ];
	
	fp = fopen(fname,"rt");
	if (fp == NULL) return -errno;
	
	if (gsl_sym) cleanup_symbol();
	gsl_sym = new_generic_slots_sorted(10, 32);
	if (!gsl_sym) return -ENOMEM;

	while (fgets(buf, BUFSIZ-1, fp) != NULL) {
		unsigned long addr;
		char buf2[BUFSIZ];
		slot_t *slot;
		sscanf(buf, "%lx %*c %s\n",&addr, buf2);
		buf2[26]='\0';
		slot = get_free_slot(gsl_sym, (slot_hkey)addr);
		if (slot ==NULL) break;
		strncpy((char*)slot_data(slot),buf2,26);
	}
	fclose(fp);
	return 0;
}

slot_t * get_symbol_slot(unsigned long addr)
{
	slot_t *slot;
	slot = find_nearest_slot(gsl_sym,(slot_hkey)addr,1);
	if (slot) {
		return slot;
	}
	return NULL;
}

char * get_symbol(unsigned long addr)
{
	slot_t *slot;
	slot = find_nearest_slot(gsl_sym,(slot_hkey)addr,1);
	if (slot) {
		return (char*)slot_data(slot);
	}
	return NULL;
}
