/*
 lksteh_procstat -- convert task struct to PID and 
         devide context switching into 2 events. 
  
 Copyright (C) HITACHI,LTD. 2005
 WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 Created by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
  
 The development of this program is partly supported by IPA
 (Information-Technology Promotion Agency, Japan).
  
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

#include <linux/version.h>
#include <linux/module.h>
#include <linux/init.h>
#include <linux/sched.h>
#include <linux/lkst_private.h>
#include "../include/extra_etypes.h"

MODULE_AUTHOR("M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>");
MODULE_DESCRIPTION("");
MODULE_LICENSE("GPL");

/* Declaration of hook header */
LKST_ETYPE_DEF_MODULE(EID_PROCESS_WAKEUP2, INLINE, PROCESS_WAKEUP2, "wakeup_pid", \
		      "wakeup pid", \
		      "process state", \
		      "synchronus",\
		      "");
LKST_ETYPE_DEF_MODULE(EID_PROCESS_CONTEXTSW2, INLINE, PROCESS_CONTEXTSW2, "contextswitch_pid", \
		      "next pid", \
		      "next task", \
		      NULL,\
		      NULL);

#include <linux/sched.h>
static void lkst_evhandler_procstat(void *phookrec, int event_type,
				     lkst_arg_t arg1, lkst_arg_t arg2,
				     lkst_arg_t arg3, lkst_arg_t arg4)
{
	preempt_disable();	/*IMPORTANT*/
	if (event_type == LKST_ETYPE_PROCESS_WAKEUP) {
		int pid = ((struct task_struct *)((long)arg1))->pid;
		lkst_evhandlerprim_entry_log(LKST_ETYPE_PROCESS_WAKEUP2,
					     LKST_ARG(pid), arg2, arg3, arg4);
	}else
	if (event_type == LKST_ETYPE_PROCESS_CONTEXTSWITCH) {
		int pid2 = ((struct task_struct *)((long)arg2))->pid;
		lkst_evhandlerprim_entry_log(LKST_ETYPE_PROCESS_CONTEXTSWITCH,
					     arg1, arg2, arg3, arg4);
		lkst_evhandlerprim_entry_log(LKST_ETYPE_PROCESS_CONTEXTSW2,
					     LKST_ARG(pid2), arg2, LKST_ARG(0),
					     LKST_ARG(0));
	}
	preempt_enable();	/*VERY IMPORTANT*/
}


static int mod_init(void);
static void mod_cleanup(void);
module_init(mod_init);		/*define as initializer*/
module_exit(mod_cleanup);	/*define as terminator*/

static LKST_EH_DEV_DEF(procstat,
		       lkst_evhandler_procstat,
		       NULL,NULL,NULL);

static int mod_init(void)
{
	int	retval;
	/* Initialization of hook header */
	retval = lkst_hook_etype_register(&LKST_ETYPE_INFO(PROCESS_WAKEUP2));
	if (retval < 0) {
		printk("lksteh_procstat: Error: failed to etype register (%d)\n", 
		       retval);
		goto init_err;
	}
	retval = lkst_hook_etype_register(&LKST_ETYPE_INFO(PROCESS_CONTEXTSW2));
	if (retval < 0) {
		printk("lksteh_procstat: Error: failed to etype register (%d)\n", 
		       retval);
		goto init_err;
	}
	/* register an event handler */
	retval = lkst_eh_device_register(&LKST_EH_DEV(procstat));
	if (retval < 0) {
		printk("lksteh_procstat: Error: failed to evhandler register (%d)\n", 
		       retval);
		goto init_err;
	}
	return 0;
	
	init_err:
	mod_cleanup(); /*If occurs an error, invokes terminator.*/
	return retval;
}

static void mod_cleanup(void)
{
	if (LKST_EH_DEV(procstat).id != LKST_EVHANDLER_ID_VOID) {
		lkst_eh_device_unregister(&LKST_EH_DEV(procstat));
	}
	lkst_hook_etype_unregister(&LKST_ETYPE_INFO(PROCESS_WAKEUP2));
	lkst_hook_etype_unregister(&LKST_ETYPE_INFO(PROCESS_CONTEXTSW2));
}
