/*
 LKST log divider

 Copyright (C) HITACHI,LTD. 2004-2005
 WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 Created by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
  
 The development of this program is partly supported by IPA
 (Information-Technology Promotion Agency, Japan).
  
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <limits.h>
#include <fcntl.h>
#include <errno.h>
#include <linux/lkst.h>
#include <linux/lkst_buffer.h>
#include "timespec.h"
#include "logfile.h"

#define VERSION "050124"

void usage(void)
{
	printf("lkstlogdiv version %s \n\tLKST log divider for lkstlogd's logfile\n",
	       VERSION);
	printf("Copyright (C) 2004-2005, HITACHI, LTD.,\n");
	printf("Usage: lkstlogdiv logfile\n");
	exit(1);
}

int write_header(FILE *fp, struct lkst_file_header *lfh) 
{
	int err = 0;;
	rewind(fp);
	err += fwrite(&lfh->head, sizeof(log_header_t), 1, fp);
	err += fwrite(&lfh->entry, sizeof(struct posix_log_entry), 1, fp);
	err += fwrite(&lfh->endian, sizeof(int), 1, fp);
	err += fwrite(&lfh->version, sizeof(int), 1, fp);
	err += fwrite(&lfh->arch, sizeof(char), LKST_ARCH_NAME_LEN, fp);
	if (err < LKST_ARCH_NAME_LEN+4 ) return -1;
	if (lfh->sync_time.posix.log_event_type == LKST_ETYPE_LKST_SYNC_TIME) {
		err = fwrite(&lfh->sync_time, sizeof(struct lkst_log_record), 1, fp);
		if (err != 1) return -1;
	}
	return 0;
}

#define MAX_CPUS 256

int main (int argc, char * argv[])
{
	int tag,line,cpu,ocpu;
	lkstlogfile_t *lfile;
	struct timespec ts, *pts;
	FILE *fp;
	char fname[PATH_MAX+1];
	
	if (argc!=2) usage();
	lfile = new_logfile(argv[1]);
	if (!lfile) usage();
	tag=0;line =0;
	do {
		int last=0;
		snprintf(fname,PATH_MAX,"%s-%d",argv[1],tag);
		fp = fopen(fname, "w+");
		if (fp ==NULL) {
			fprintf(stderr, "error: cannot open \"%s\"\n", fname);
			exit(2);
		}
		if (write_header(fp, &lfile->header) < 0) {
			fprintf(stderr, "error: cannot write \"%s\"\n", fname);
			exit(3);
		}
		
		ts.tv_sec = 0;
		ts.tv_nsec = 0;
		pts = &lfile->entry.posix.log_time;
		ocpu = lfile->entry.posix.log_processor;
		do {
			int etype;
			etype = lfile->entry.posix.log_event_type;
			cpu = lfile->entry.posix.log_processor;
			if (etype == LKST_ETYPE_LKST_OVWRTN_REC) {
				printf("warning: line %d : overwritten detected!\n",
				       line);
			}
			if ((etype <= 0xff0 || cpu!=ocpu) &&
			    timespec_lt(*pts, ts) ) {
				printf("line:%d timespec %lu.%09lu(%x) less than %lu.%09lu(%x)\n",
				       line , pts->tv_sec, pts->tv_nsec,lfile->entry.posix.log_event_type,
				       ts.tv_sec, ts.tv_nsec,last);
				break;
			}
			if (fwrite(&lfile->entry, sizeof(struct lkst_log_record),1,fp) < 1) {
				fprintf(stderr, "error: cannot write \"%s\":%s\n",
					fname,strerror(ferror(fp)));
				exit(3);
			}
			if( lfile->entry.posix.log_event_type <= 0xff0 ) {
				ts = *pts;
				last = lfile->entry.posix.log_event_type;
			}
			ocpu = cpu;
			line ++;
		}while(logfile_read_one(lfile) == 1) ;
		fclose(fp);
		tag++;
	}while (!feof(lfile->fp));
	return 0;
}
