/*
 LKST run-queue analyzer

 Copyright (C) HITACHI,LTD. 2004,2005
 WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 Created by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
 Updated by H.Kawai <h-kawai@sdl.hitachi.co.jp>
  
 The development of this program is partly supported by IPA
 (Information-Technology Promotion Agency, Japan).
  
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <limits.h>
#include <linux/lkst.h>
#include <linux/lkst_buffer.h>
#include <lkstla.h>
#include <eventdesc.h>
#include <extra_etypes.h>

static int init_runqueue(void);
static slot_hkey info_key_runqueue(struct lkst_log_record *rec_start, struct lkst_log_record *rec_end);
static char * get_alias_runqueue(slot_hkey key);
static ga_type_t get_type_runqueue(struct lkst_log_record *rec);
static double get_metric_runqueue(struct lkst_log_record *rec_start,
				 struct lkst_log_record *rec_end);

struct gate_analyzer runqueue_analyzer = {
	.name = "runqueue",
	.description = "Run-queue length analyzer",
	.cols = {
		[COL_KEY] = { "cpuid", 5, "%*d" },
		[COL_ALIAS] = { "cpu", 7, "%*s" },
		[COL_METRIC] = { "runqueue-len" },
	},

	GA_INIT_EVENT_ANALYZER
	GA_INIT_NO_EXTRAOPTS
	GA_INIT_DEF_LONG
	GA_INIT_RET_EVENT_TIME
	GA_INIT_RET_EVENT_PID

	.info_key = info_key_runqueue,
	.get_alias = get_alias_runqueue,

	.get_type = get_type_runqueue,
	.get_metric = get_metric_runqueue,

	.init = init_runqueue,
};

static generic_slots_t *gsl_info=NULL;

static int init_runqueue(void)
{
	gsl_info = new_generic_slots(4,8);
	if (gsl_info == NULL)return -ENOMEM;
	return 0;
}

static slot_hkey info_key_runqueue(struct lkst_log_record *rec_start,
				   struct lkst_log_record *rec_end)
{
	slot_hkey key = rec_start->posix.log_processor;
	if (find_slot(gsl_info, key) == NULL) {
		slot_t *s;
		s = get_free_slot(gsl_info,key);
		if (s)
			snprintf((char*)slot_data(s), 7, "CPU-%d", (int)key);
	}
	return key;
}

static char * get_alias_runqueue(slot_hkey key)
{
	slot_t *s = find_slot(gsl_info, key);
	if (s) {
		return (char *)slot_data(s);
	}else
		return "(unknown)";
}

static ga_type_t get_type_runqueue(struct lkst_log_record *rec)
{
	if (rec->posix.log_event_type == LKST_ETYPE_PROCESS_CONTEXTSWITCH)
		return GAT_EVENT;
	else
		return GAT_IGNORE;
}

static double get_metric_runqueue(struct lkst_log_record *rec_start,
				 struct lkst_log_record *rec_end)
{
	return (double)ARG4UL(rec_end);
}
