/*
 timer delay distribution analyzer

 Copyright (C) HITACHI,LTD. 2004-2005
 WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 Created by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
 Updated by H.Kawai <h-kawai@sdl.hitachi.co.jp>
  
 The development of this program is partly supported by IPA
 (Information-Technology Promotion Agency, Japan).
  
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <limits.h>
#include <linux/lkst.h>
#include <linux/lkst_buffer.h>
#include <lkstla.h>
#include <ksymbols.h>

static slot_hkey info_key_timer(struct lkst_log_record *rec_start, struct lkst_log_record *rec_end);
static char * get_alias_timer(slot_hkey key);
static ga_type_t get_type_timer(struct lkst_log_record *rec);
static double get_metric_timer(struct lkst_log_record *st,
			      struct lkst_log_record *en);


struct gate_analyzer timer_analyzer = {
	.name = "timer",
	.description = "timer delay analyzer",
	.cols = {
		[COL_KEY] = { "address", ADDR_LEN, "%0*lx" },
		[COL_ALIAS] = { "timer_name", 26, "%*s" },
		[COL_METRIC] = { "delayed-time" },
	},

	GA_INIT_EVENT_ANALYZER
	GA_INIT_DEF_TIME
	GA_INIT_RET_EVENT_TIME
	GA_INIT_RET_EVENT_PID

	.info_key = info_key_timer,
	.get_alias = get_alias_timer,

	.get_type = get_type_timer,

	.init = init_ksymbols,

	.nr_options = 1,
	.options[0] = &ksym_option,
	.get_metric = get_metric_timer,
};

static double get_metric_timer(struct lkst_log_record *st,
			      struct lkst_log_record *en)
{
	double ret;
	if (en) {
		ret = (double)en->log_arg3;
		return ret/(1000*1000);
	}else {
		return 0;
	}
}

static slot_hkey info_key_timer(struct lkst_log_record *rec_start, struct lkst_log_record *rec)
{
	return ARG1UL(rec);
}

static char * get_alias_timer(slot_hkey key)
{
	char *ret=get_symbol(key);
	if (ret == NULL)
		return "(unknown)";
	else
		return ret;
}

static ga_type_t get_type_timer(struct lkst_log_record *rec)
{
	if (rec->posix.log_event_type == LKST_ETYPE_TIMER_RUN) 
		return GAT_EVENT;
	else
		return GAT_IGNORE;
}
