/*
 waitqueue waittime distribution analyzer

 Copyright (C) HITACHI,LTD. 2004-2005
 WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 Created by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
 Updated by H.Kawai <h-kawai@sdl.hitachi.co.jp>
  
 The development of this program is partly supported by IPA
 (Information-Technology Promotion Agency, Japan).
  
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <limits.h>
#include <linux/lkst.h>
#include <linux/lkst_buffer.h>
#include <lkstla.h>
#include <ksymbols.h>
#include <logfile.h>
#include <extra_etypes.h>

static slot_hkey info_key_waittime(struct lkst_log_record *rec_start, struct lkst_log_record *rec_end);
static char * get_alias_waittime(slot_hkey key);
static ga_type_t get_type_waittime(struct lkst_log_record *rec);
static slot_hkey session_key_waittime(struct lkst_log_record *rec);

static generic_slots_t *gsl_info=NULL;

static int init_waittime(void)
{
	int ret;
	if ((ret = init_ksymbols()) <0) return ret;
	gsl_info = new_generic_slots_sorted(5,33);
	if (gsl_info == NULL)return -ENOMEM;
	return 0;
}

struct gate_analyzer waittime_analyzer = {
	.name = "waittime",
	.description = "waiting time on waitqueue analyzer",
	.cols = {
		[COL_KEY] = { "address", ADDR_LEN, "%0*lx" },
		[COL_ALIAS] = { "calling_point", 32, "%*s" },
		[COL_METRIC] = { "wait-time" },
	},

	GA_INIT_SESSION_ANALYZER
	GA_INIT_1TO1_SESSION
	GA_INIT_RET_SESSION_TIME
	GA_INIT_RET_EVENT_PID
		
	.info_key = info_key_waittime,
	.session_key = session_key_waittime,
	.get_alias = get_alias_waittime,

	.get_type = get_type_waittime,

	.init = init_waittime,

	.nr_options = 1,
	.options[0] = &ksym_option,
};

static slot_hkey session_key_waittime(struct lkst_log_record *rec)
{
	return XORL(rec->log_arg1, rec->posix.log_pid);
}

static slot_hkey info_key_waittime(struct lkst_log_record *rec_start, struct lkst_log_record *rec)
{
	slot_hkey key = ARG3UL(rec_start);
	if (find_slot(gsl_info, key) == NULL) {
		slot_t *s,*p;
		char buf[32]="";
		p = get_free_slot(gsl_info,key);
		s = get_symbol_slot(key);
		if (p) { 
			if (s) strncpy(buf, (char*)slot_data(s),23);
			buf[23] = '\0';
			snprintf((char*)slot_data(p), 32, "%s+%lx",
				 buf, (p->key - s->key));
		}
	}
	return key;
}

static char * get_alias_waittime(slot_hkey key)
{
	slot_t *s = find_slot(gsl_info, key);
	if (s) {
		return (char *)slot_data(s);
	}else
		return "(unknown)";
}

static ga_type_t get_type_waittime(struct lkst_log_record *rec)
{
	switch (rec->posix.log_event_type) {
	case LKST_ETYPE_PROCESS_ADD_WQ:
	case LKST_ETYPE_PROCESS_CNT_WQ:
		return GAT_START;
	case LKST_ETYPE_PROCESS_REM_WQ:
		return GAT_END;
	default:
		return GAT_IGNORE;
	}
}
