.TH lkstbuf 8
.SH NAME
lkstbuf \- Control kernel event buffer in LKST.
.br
.SH SYNOPSIS
lkstbuf \fIcommand\fR [ \fIoption(s)\fR ]
.SH DESCRIPTION
This command controls kernel event buffer in LKST such as creation, deletion, changing, reading, formatting, and listing of all buffers.
.SH COMMANDS
.TP
\fBlink/ln \fB\-b \fIbuffer_id\fR \fR[\fB\-n \fInext_buffer_id\fR] \fR[\fB\-c \fIcpu_id\fR]
Change destination buffer for the shift operation.
.TP 1i
.B \ \ \ \ \ \ \-b \fIbuffer_id
Specify the id of a buffer.
.TP 1i
.B \ \ \ \ \ \ \-n \fInext_buffer_id
Specify the id of the destination buffer. If omitted, clear destination of
specified buffer.

.B NOTE:
You can specify a buffer doesn't exist yet to destination, except itself.
However, you must fail to shift while it doesn't exist.
.TP 1i
.B \ \ \ \ \ \ \-c \fIcpu_id
Specify the id of a CPU of which buffer is changed. If omitted, buffers
which have specified id in each CPU are changed. The id must be same as
described in "\fI/proc/cpuinfo\fR".

.TP
\fBshift \fR[\fB\-c \fIcpu_id\fR]
Change currently selected buffer to next buffer.

.B NOTE:
If destination buffer does not exist, this operation would fail.
.TP 1i
.B \ \ \ \ \ \ \-c \fIcpu_id
Specify the id of a CPU of which buffer is changed. If omitted, buffers
which have specified id in each CPU are changed. The id must be same as
described in "\fI/proc/cpuinfo\fR".
.TP
\fBjump \fB\-b \fIbuffer_id \fR[\fB\-c \fIcpu_id\fR]
Change currently selected buffer to specified buffer.
.TP 1i
.B \ \ \ \ \ \ \-b \fIbuffer_id
Specify the id of a buffer.
.TP 1i
.B \ \ \ \ \ \ \-c \fIcpu_id
Specify the id of a CPU of which buffer is changed. If omitted, buffers
of all CPUs are changed. The id must be same as described in
"\fI/proc/cpuinfo\fR".
.TP
\fBcreate \fB-s \fIsize\fR[\fBK\fR|\fBM\fR] [\fB\-b \fIbuffer_id\fR] [\fB\-n \fInext_buffer_id\fR] [\fB-c \fIcpu_id\fR]
Create a new event buffer.
.TP 1i
.B \ \ \ \ \ \ \-s \fIsize\fR[\fBK\fR|\fBM\fR]
Specify size of a buffer. \fIsize \fRis followed by \fBK 
\fRand \fBM \fRsuffixes representing size in Kilo bytes and in Mega bytes,
respectively.
.TP 1i
.B \ \ \ \ \ \ \-b \fIbuffer_id
Specify the id of a buffer(s) to be created. If omitted, the unused id is
selected automatically.
.TP 1i
.B \ \ \ \ \ \ \-n \fInext_buffer_id
Specify the id of the destination buffer. If omitted, clear the destination of
new buffer(s).
.TP 1i
.B \ \ \ \ \ \ \-c \fIcpu_id
Specify the id of a CPU of which the buffer is created. The id must be
same as described in "/proc/cpuinfo". If omitted, new buffers are
created in each CPU.
.TP
\fBdelete/del \fB\-b \fIbuffer_id \fR[\fB-c \fIcpu_id\fR]
Delete an event buffer.
.TP 1i
.B \ \ \ \ \ \ \-b \fIbuffer_id
Specify the id of a buffer to be deleted.
.TP 1i
.B \ \ \ \ \ \ \-c \fIcpu_id
Specify the id of a CPU of which the buffer is deleted. The id must be
same as described in "/proc/cpuinfo". If omitted, all buffers those have 
\fIbuffer_id \fRid are deleted in each CPU (if exist).
.TP
\fBlist/ls \fR[\fB\-c \fIcpu_id\fR] [\fB\-v\fR] 
Output the list of all kernel event buffers.
.TP 1i
.B \ \ \ \ \ \ \-c \fIcpu_id
Specify the id of a CPU to list. The id must be same as described 
in "/proc/cpuinfo". If omitted, all buffers those have 
\fIbuffer_id \fRid are deleted in each CPU (if exist).
.TP 1i
.B \ \ \ \ \ \ \-v
Specify that the list of buffers display as verbose format.
.TP 
\fBread \fR[\fB\-c \fIcpu_id\fR] [\fB\-b \fIbuffer_id\fR] [\fB-f \fIoutput_file\fR]
[\fB-n \fInumber\fR] [\fB-E \fIetype_list_file\fR]
.TP 
\fBread -S [\fB-f \fIoutput_file\fR] [\fB-n \fInumber\fR] [\fB-E \fIetype_list_file\fR]
Read the contents of an event buffer/event buffers.
.TP 1i
.B \ \ \ \ \ \-c \fIcpu_id
Specify the id of a cpu to read from. If omitted, all buffers those have
\fIbuffer_id id are read.
.TP 1i
.B \ \ \ \ \ \-b \fIbuffer_id
Specify the id of a buffer to be read. If omitted, all buffers owned by
\fIcpu_id \fRare read. Neither \fIcpu_id \fRnor \fIbuffer_id \fRis specified, 
all buffers in system are read (except for static buffer )
.TP 1i
.B \ \ \ \ \ \-S
Specify that the command read from static buffer.
.TP 1i
.B \ \ \ \ \ \-f \fIoutput_file
Specify the output file. If omitted, this command displays the
content.
.TP 1i
.B \ \ \ \ \ \-n \fInumber
Specify the number of read entry of the buffer. If omitted, all entries
of the buffer are read.
.TP 1i
.B \ \ \ \ \ \-E \fIetype_list_file
Specify event-type list file. If omitted, only embedded events are 
shown. Usually, you can get this list from /proc/lkst_etypes.
.PP

.TP
\fBprint \fB\-f \fIlog_file \fR[\fB\-c \fIcpu_id\fR] \fR[\fB\-e
\fIevent_name ...\fR] [\fB\-h\fR] [\fB-n \fIentry_num\fR] [\fB-r\fR | \fB-d\fR] [\fB-C [\fB-S\fR]\fR] [\fB-V\fR] [\fB-E \fIetype_list_file\fR]

Format LKST trace data.
.TP 1i
.B \ \ \ \ \ \-f \fIlog_file
Specify the file containing binary trace data, which is created by using lkstbuf read or lkstlogd.
(Also use kerenl crash dump file by using LKCD.)
.TP 1i
.B \ \ \ \ \ \-c \fIcpu_id
Specify the cpu number.
.TP 1i
.B \ \ \ \ \ \-e \fIevent_name ...
Specify event filter.
Enumerate the names of events which you want to trace.
( Event name list is displayed by option \fB\-h\fR. )
Each event is separated by comma.

example(1) Display only "\fBsystem_call_entry\fR" and "\fBsystem_call_exit\fR".

.B \-e system_call_entry,system_call_exit

If you don't want to trace some events, specify "\fB!\fR" followed by the
names of the events, like "\fB!system_call_entry\fR". 
You can specify "\fBall\fR" to specify all events.

example(2) Display all events except for "\fBsystem_call_entry\fR"
and "\fBsystem_call_exit\fR".

.B \-e all,!system_call_entry,!system_call_exit

.B NOTE:
Enumerated event name is evaluated from the left to the right.
If both display and non\-display are specified for the same
event, the specification of the right side is given to priority.

.B \-e all,!spin_lock
=> display all events except spin_lock
.br
.B \-e !spin_lock,all
=> display all events
.br
.B \-e !spin_lock,spin_lock
=> the same as "\fB-e spin_lock\fR"
.br
.B \-e spin_lock,!spin_lock
=> the same as "\fB-e !spin_lock\fR"
.TP 1i
.B \ \ \ \ \ \-h
Display command help.
( Also event name list is displayed. )
.TP 1i
.B \ \ \ \ \ \-n \fIentry_num
Specify the number of output entry.
.TP 1i
.B \ \ \ \ \ \-r
Reverse the order of output record.
.br
(default : time descending sort)
.TP 1i
.B \ \ \ \ \ \-d
Dump records (without sort)
.br
.TP 1i
.B \ \ \ \ \ \-E \fIetype_list_file
Specify event-type list file. If omitted, only embedded events are 
shown. Usually, you can get this list from /proc/lkst_etypes.
.TP 1i
.B \ \ \ \ \ \-V
Verbose mode.
.br
Display all arguments.(default : display only commented arguments.)
.TP 1i
.B \ \ \ \ \ \-C [-S]
Dislpay trace data by CSV format.
.br
The meaning of column in the CSV format is explained.
.br
First column is event name or event number.
.br
Second  column is CPU number.
.br
Third  column is process id.
.br
4th-8th columns are date which an event caused.
.br
	...,day of week, month, day, hour,year,...
.br
9th column is name of parameter.
.br
10th column is value  of parameter.(under 32bit)
.br
11th column is value  of parameter.(upper 32bit)
.br
	... following ,same mean 9th-11th column.
.br
when you specify -S option, print short format of date as follows(4th-5th colums)
.br
	...,second,nano-second
.br
.PP

.TP
\fBversion/ver
Print version of this command.
.PP
.TP
\fBhelp
Print help message.
.PP

.SH RETURN VALUE
.TP
.B 0
success
.TP
.B Except 0
failure
.SH REFERENCES
.BR lkst (8),
.BR ioctl(LKST_IOC_BUFFER_READ) (2),
.BR ioctl(LKST_IOC_BUFFER_LIST) (2),
.BR ioctl(LKST_IOC_BUFFER_LINK) (2),
.BR ioctl(LKST_IOC_BUFFER_JUMP) (2),
.BR ioctl(LKST_IOC_BUFFER_CREATE) (2),
.BR ioctl(LKST_IOC_BUFFER_DELETE) (2)


