#!/bin/bash
# LKST check helper script (interactive script)
# COPYRIGHT (C) HITACHI,LTD. 2004
# Created by K.OGASAWARA<ogasawar@sdl.hitachi.co.jp>
# Updated by M.Hiramatsu<hiramatu@sdl.hitachi.co.jp>

#<env>
LKSTDIR=`pwd`
LKSTCMD=$LKSTDIR/lkstutils
LKSTADD=$LKSTDIR/lkstaddons
#LKSTCMD=/usr/sbin/
#LKSTADD=/lib/modules/'uname -r'/kernel/drivers/lkst/

LKST=$LKSTCMD/lkst
LKSTM=$LKSTCMD/lkstm
LKSTBUF=$LKSTCMD/lkstbuf
LKSTEH=$LKSTCMD/lksteh
LKSTLOGD=$LKSTCMD/lkstlogd

MODPROBE=/sbin/modprobe
INSMOD=/sbin/insmod
RMMOD=/sbin/rmmod
LSMOD=/sbin/lsmod
TMPDIR=/tmp
#</env>

if [ `id -u` -ne 0 ]; then
	echo "Error: must be root"
	exit 1;
fi

if [ ! -e $LKSTDIR ]; then
	echo "Error: $LKSTDIR not exist"
	exit 1;
fi

echo "!NOTE! This version supports interactive mode only!"
#TODO : test automatically.

function waiting () {
local EXEC
local ANSWER
EXEC=$1
echo -n ">>"
while [ "$1" ]; do
 echo $1
 shift
done
echo -n "press return key:"
read ANSWER
[ "$EXEC" ] && eval $EXEC
}

#<load>
waiting "$MODPROBE lkst" 
$LSMOD
echo "Start to check."
#</load>

#<display status>
waiting "$LKST ver"
waiting "$LKST all"
waiting "$LKST stat"
CPUS=`cat /proc/cpuinfo | grep ^processor | wc -l`
#</display status>

#<startorstop>
waiting "$LKST stop"
waiting "$LKST start"
waiting "$LKSTM set -m 1"
waiting "$LKST start"
#</startorstop>

#<maskset>
waiting "$LKSTM ver"
waiting "$LKSTM ls"
waiting "$LKSTM read"
waiting "$LKSTM read -m 0"
waiting "$LKSTM read -m 1"
waiting "$LKSTM read -m 2"
waiting "$LKSTM read -m 3" "Maybe here is error."
waiting "$LKSTM read | $LKSTM write -f - "
waiting "$LKSTM read | $LKSTM write -f - -n mask2"
waiting "$LKSTM config -n mask2 0x020 0x0ff"
waiting "$LKSTM read -n mask2"
waiting "$LKSTM del -m 3"
#</maskset>

#<buffer>
waiting "$LKSTBUF ver"
waiting "$LKSTBUF ls"
waiting "$LKSTBUF ls -v"
waiting "$LKSTBUF ls -v -c 0"
waiting "$LKSTBUF ls -v -c $CPUS" "Maybe here is error."
# TODO : The size of buffers are calculated automatically from available memory size.
waiting "$LKSTBUF create -s 10M"
waiting "$LKSTBUF create -s 20K"
waiting "$LKSTBUF create -s 4096 -b 4"
waiting "$LKSTBUF create -s 16384 -c $CPUS" "Maybe here is error."
waiting "$LKSTBUF del -b 4"
waiting "$LKSTBUF del -b 2 -c $CPUS" "Maybe here is error."
waiting "$LKSTBUF ln -b 1 -n 2"
waiting "$LKSTBUF ln -b 1"
waiting "$LKSTBUF ln -b 1 -n 2 -c $CPUS" "Maybe here is error"
#
waiting "$LKSTBUF ln -b 0 -n 2"
#
waiting "$LKSTBUF shift"

waiting "$LKSTBUF shift -c $CPUS" "Maybe here is error"
waiting "$LKSTBUF jump -b 0"
waiting "$LKSTBUF jump -b 2 -c 2" "Maybe here is error"
waiting "$LKSTBUF read -f $TMPDIR/lkstbuf.log.tmp"
waiting "$LKSTBUF print -f $TMPDIR/lkstbuf.log.tmp"
rm $TMPDIR/lkstbuf.log.tmp
waiting "$LKSTBUF read -S"
waiting "$LKSTBUF print" "Maybe here is error"
waiting "$LKSTBUF read -c $CPUS" "Maybe here is error"
#</buffer>

#<evhandler>
waiting "$LKSTEH ver"
waiting "$LKSTEH ls"
waiting "$LKSTEH find -n LOG_STATIC"
waiting "$INSMOD $LKSTADD/lkst_mod_rec_selected_proc.ko"
$LSMOD
waiting "echo 1 | $LKSTEH c -e 32 -f -"
waiting "$RMMOD lkst_mod_rec_selected_proc"
$LSMOD
#</evhandler>

#<daemon>
waiting "$LKSTLOGD -a"
$LKSTBUF ls
echo "Just a wait for LKST to write log" 
for C in 1 2 3 4 5; do
	find /lib &> /dev/null && sync && echo -n "."
done
echo
waiting "$LKSTBUF print -f /var/log/lkst/sebuf00.0"
__TMP_PID=`cat /var/run/lkstlogd.pid`
waiting "kill -USR2 `cat /var/run/lkstlogd.pid`"
ls -l /var/log/lkst
waiting "kill -USR1 `cat /var/run/lkstlogd.pid`"
ls -l /var/log/lkst
waiting "kill -TERM `cat /var/run/lkstlogd.pid`"
#</daemon>

#<unload>
waiting "$RMMOD lkst"
$LSMOD
echo "Finish to check."
#</unload>

exit 1
