#!/bin/sh 
# A script to apply patches of LKST
# COPYRIGHT (C) HITACHI,LTD. 2004,2005
# Written by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
# Usage: enpatch.sh <target (kernel source) directory> [patch directory]
# Example) ./enpatch.sh /usr/src/linux-xxx ../patches

SCRDIR=`dirname $0`
[ "$SCRDIR" ] || SCRDIR=`pwd`
source $SCRDIR/../lkst.version
source $SCRDIR/functions

TARGET=$1
PATDIR=$2

function usage() {
    echo "Usage: enpatch.sh <target (kernel source) directory> [patch directory]"
    echo "      Example) ./enpatch.sh /usr/src/linux-xxx "
}
if [ ! -d "$TARGET" ] ;then
    echo "Error: Target directory is not found: "$TARGET
    usage
    exit 0
fi
LOGFILE=$TARGET/lkst-patch.log

[ "$PATDIR" ] || PATDIR=`rp2ap $SCRDIR/../patches`
if [ ! -d "$PATDIR" -o ! -f "$PATDIR/kernel.version" ]; then 
    echo "Error: Patch direcotry or version file are not found: "$PATDIR
    usage
    exit 0
fi
source $PATDIR/kernel.version
BASE_KERNEL_ABBR=`mkabbr $BASE_KERNEL`

function kpatch () {
    echo  Apply $1 Patch >> $LOGFILE
    patch -d $TARGET -p1 < $1 >> $LOGFILE
}

confirm "Apply preassigned page table patch (if not, apply vmsync patch automatically)" "Y"
PAPTE=$?
[ $PAPTE -eq 1 ] && kpatch $PATDIR/preassigned-$BASE_KERNEL.patch
[ $PAPTE -eq 0 ] && kpatch $PATDIR/vmsync-$BASE_KERNEL.patch
kpatch $PATDIR/kernelhooks-v1.8-$BASE_KERNEL_ABBR-base.patch
kpatch $PATDIR/kernelhooks-v1.8-fix_kconfig.patch
kpatch $PATDIR/kernelhooks-v1.8-fix_kmakefile.patch
kpatch $PATDIR/kernelhooks-v1.8-resolve_dependency.patch
kpatch $PATDIR/kernelhooks-v1.8-support_ia64.patch
kpatch $PATDIR/kernelhooks-v1.8-support_x86_64.patch
kpatch $PATDIR/lkst-core.patch
kpatch $PATDIR/lkst-events-std.patch
confirm "Apply performace analyzing patch(recommend)" "Y"
[ $? -eq 1 ] && kpatch $PATDIR/lkst-events-perf.patch
confirm "Apply early boot-time tracing patch(optional)" "N"
[ $? -eq 1 ] && kpatch $PATDIR/lkst-earlylog.patch
confirm "Apply extra event set patch(optional)" "N"
[ $? -eq 1 ] && kpatch $PATDIR/lkst-events-ext1.patch
confirm "Apply ignore hooks placed in inline-functions patch(optional)" "N"
[ $? -eq 1 ] && kpatch $PATDIR/lkst-ign-inline.patch
[ $PAPTE -eq 0 ] && kpatch $PATDIR/lkst-use_vmsync.patch
echo "done. Logs are written in " $LOGFILE "."
