%define name lkstutils
%define version 2.0.0
%define release 1

%define prefix /usr

%define withlkcd 0

%{?_without_lkcd: %{expand: %%define withlkcd 0}}
%{?_with_lkcd: %{expand: %%define withlkcd 1}}

%ifarch ia64
%define withlkcd 0
%endif

%if %{withlkcd}
%define lkcdconfig --enable-lkcd
%else
%define lkcdconfig --disable-lkcd
%endif

Name: %{name}
Summary: Linux Kernel State Tracer (LKST) Utilities
Version: %{version}
Release: %{release}
Packager: HITACHI,LTD. FUJITSU,LTD.
Group: Applications/System
Source: %{name}-%{version}.tar.gz
License: GPL
Vendor: HITACHI,LTD. FUJITSU,LTD.
URL: http://sourceforge.net/projects/lkst/
BuildRoot: %{_tmppath}/%{name}-root/
BuildPreReq: autoconf
%if %{withlkcd}
BuildPreReq: lkcdutils >= 4.1
Requires: lkcdutils >= 4.1
%endif

%description
The lkstutils package contains user tools for
Linux Kernel State Tracer (LKST). It includes
the following tools.

- lkstbuf         Control kernel event buffer in LKST.
- lksteh          Control event-handler in LKST. 
- lkst            Control status of LKST.
- logformat.pl    display LKST trace data
- lkstm           Control maskset in LKST.
- lkstlogd        LKST logging utility.
- lkstlogger      Tells LKST that a specified event has occurred.

Authors:
--------
   K.SERIZAWA <serizawa@sdl.hitachi.co.jp>
   T.NAKAMURA <tetsu@crl.hitachi.co.jp>
   K.HATASAKI <keisukeh@crl.hitachi.co.jp>
   Y.GOTO <y-goto@jp.fujitsu.com> 
   T.INDOH <indou.takao@jp.fujitsu.com>
   M.HIRAMATSU <hiramatu@sdl.hitachi.co.jp>

%prep
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT
%setup
%build
autoconf
./configure --prefix=%{prefix} \
	    --with-ksrc=/usr/src/linux \
	    --mandir=%{_mandir} \
	    %{lkcdconfig}
make

%install
mkdir -p $RPM_BUILD_ROOT%{prefix}/sbin
mkdir -p $RPM_BUILD_ROOT%{prefix}/share/sial/lcrash
mkdir -p $RPM_BUILD_ROOT%{_mandir}/man1
mkdir -p $RPM_BUILD_ROOT%{_mandir}/man8
make LKSTLOGD_LOGDIR=$RPM_BUILD_ROOT/var/log/lkst \
     prefix=$RPM_BUILD_ROOT%{prefix} \
     mandir=$RPM_BUILD_ROOT%{_mandir} \
     MKDEV= \
     install
#mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}
#install -m 644 redhat/lkstlogd $RPM_BUILD_ROOT%{_sysconfdir}
mkdir -p $RPM_BUILD_ROOT%{_initrddir}
install -m 755 redhat/lkst.init $RPM_BUILD_ROOT%{_initrddir}/lkst
install -m 755 redhat/lkstlogd.init $RPM_BUILD_ROOT%{_initrddir}/lkstlogd


%clean
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT

%post
[ -c /dev/lkst ] || mknod --mode=600 /dev/lkst c 231 0
chkconfig --add lkst
chkconfig --add lkstlogd

%preun
chkconfig --del lkst
chkconfig --del lkstlogd

%files
%defattr(-, root, root)
%doc redhat/*
#%config(missingok) %{_sysconfdir}/lkstlogd
%{_initrddir}/lkst
%{_initrddir}/lkstlogd
%{prefix}/sbin/lkstbuf
%{prefix}/sbin/lksteh
%{prefix}/sbin/lkst
%{prefix}/sbin/lkstm
%{prefix}/sbin/logformat.pl
%{prefix}/sbin/lkstlogd
%{prefix}/sbin/lkstlogger
%{_mandir}/man8/*
%{_mandir}/man1/*
%dir /var/log/lkst
%if %{withlkcd}
%{prefix}/share/sial/lcrash/lkstdump.sial
%{prefix}/share/sial/lcrash/lkstdumplib.so
%endif

%changelog
* Wed Aug 27 2003 HITACHI,LTD., FUJITSU,LTD.
- add --with-lkcd/--without-lkcd option. 

* Wed Jul 30 2003 HITACHI,LTD., FUJITSU,LTD.
- fix Copyright tag to License tag.

* Thu May  8 2003 HITACHI,LTD., FUJITSU,LTD.
- Add Requires.
- Don't make lkstdump on ia64

* Mon Feb 17 2003 HITACHI,LTD., FUJITSU,LTD.
- Fix build-requirements.

* Mon Feb 17 2003 HITACHI,LTD., FUJITSU,LTD.
- Upgrade against for v1.4

* Mon Nov 25 2002 HITACHI,LTD., FUJITSU,LTD.
- Fixed some bugs.

* Fri Aug 30 2002 HITACHI,LTD., FUJITSU,LTD.
- Release v1.3
  Performance improvement of Kernel Hooks.
  Modify default maskset.
  Support CSV format by lkstbuf command.
  Add and modify APIs for event-handler.
  Add config to delete hooks on inline func.
  Add script to make /dev/lkst.
  Fix some bugs.

* Mon May 13 2002 Masami HIRAMATSU <hiramatu@sdl.hitachi.co.jp>
- customize from original.(rel 2)
