#! /bin/awk -f
# convert from csv to *-tab.h

BEGIN {
	TRUE = 1
	FALSE = 0

	FS = ","
	OFS = ""

	nest = 1
}

(NR == 1) {
	next
}

$2 ~ /\"\/\*.*\*\/\"/ {
	gsub( /^\"/, "", $2 )
	gsub( /\"$/, "", $2 )
	printf "%s\n", $2

	next
}

{
	flg_tab = TRUE
	for( i = 2; i <= NF; i++ ){
		gsub( /\"\"/, "\"", $i )
		gsub( /^\"/, "", $i )
		gsub( /\"$/, "", $i )
		gsub( /^\"$/, "\"\"", $i )

		if( $i ~ /\\n/ ){
			flg_tab = TRUE
			printf "\n"
			continue
		}

		if( $i ~ /^}?$/ ){
			nest--
			if( nest < 1 )
				nest = 1;
		}

		if( flg_tab ~ TRUE ){
			flg_tab = FALSE
			for( j = 1; j <= nest; j++ ){
				printf "\t"
			}
		}
		if( $i ~ /^$/ ){
		} else if( $i ~ /^{$/ ){
			printf "{"
		} else if( $i ~ /^},?$/ ){
			printf "},"
		} else if( $i ~ /\/\*.*\*\// ){
			printf "%s", $i
		} else if( $i ~ /^\|/ ){
			printf "%s", $i
		} else if( $i ~ /\/\* *\|.*\*\// ){
			printf "%s", $i
		} else if( $i ~ /^\(FLG_NULL/ ){
			printf "%s", $i
		} else if( $i ~ /^\( *\| FLG_/ ){
			printf "%s", $i
		} else if( i == NF ){
			printf "%s,", $i
		} else if( $(i + 1) ~ /\\n/ ){
			printf "%s,", $i
		} else {
			printf "%s, ", $i
		}

		if( $i ~ /^{$/ ){
			nest++
		}
	}
}
