/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2006 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: request.h,v 1.32 2006/01/12 08:51:38 bowkenken Exp $
***************************************************************/

#ifndef	REQUEST_H
#define	REQUEST_H

/***************************************************************
* ΰ
***************************************************************/

#include	"item.h"
#include	"chr.h"
#include	"menu.h"

/***************************************************************
* ο
***************************************************************/

/*  */
#define	REQUEST_MAX_N	64
/* ʿѿ */
#define	REQUEST_AVE_N	32

/* åκĹ */
#define	REQUEST_MSG_MAX_LEN	1024

/***************************************************************
* μ
***************************************************************/

typedef enum {
	REQUEST_KIND_NULL,

	/* ƥõ */
	REQUEST_KIND_RARE_GOODS,
	/* ץ */
	REQUEST_KIND_TAME_MNSTR,
	/* ߽ */
	REQUEST_KIND_RESCUE,
	/* Ѹ */
	REQUEST_KIND_TOUR_GUIDE,
	/* 󥹥༣ */
	REQUEST_KIND_EXTERMINATE,
	/* Ƥ */
	REQUEST_KIND_REVENGE,
	/* ޶ */
	REQUEST_KIND_WANTED_CRIMINAL,

	REQUEST_KIND_MAX_N,
} request_kind_t;

/***************************************************************
* Υǡ
***************************************************************/

typedef struct request_t {
	/*  */
	request_kind_t	kind;
	/* Ǿ, 糬, Ūγ */
	long	dun_min_lev, dun_max_lev, dun_true_lev;
	/* ޶ */
	gold_t	prize;
	/* 󽷷и */
	long	exp;
	/*  */
	long	limit;

	/* ե饰 */
	bool_t	flg_contract;
	/* Сΰե饰 */
	bool_t	flg_contract_mbr;
	/* ̾ */
	n_msg_idx_t	idx_contract_name;
	/*  */
	sex_t	contract_sex;
	/* ãե饰 */
	bool_t	flg_finish;

	/* õ륢ƥμ */
	rare_goods_kind_t	rare_goods_kind;

	/* ɸŨ NPC ? */
	bool_t	flg_mnstr_is_npc;
	/* ɸΥ󥹥μ */
	mnstr_kind_t	mnstr_kind;
	/* ɸΥ󥹥ο */
	long	mnstr_n;
	/* ݤ󥹥ο */
	long	mnstr_exterminate_n;

	/* ꥹȾθФ */
	char	heading[MENU_MSG_MAX_LEN + 1];
	/* åΥǥå */
	n_msg_idx_t	idx_fmt;
	/* å */
	char	msg[REQUEST_MSG_MAX_LEN + 1];

	/* ̾Υǥå */
	n_msg_idx_t	idx_client_name;
	/* 󥹥̾Υǥå */
	n_msg_idx_t	idx_mnstr_name;
	/* ߽ NPC ̾Υǥå */
	n_msg_idx_t	idx_rescue_trgt_name;
	/* β²̾Υǥå */
	n_msg_idx_t	idx_client_family_name;
	/* ֤̾Υǥå */
	n_msg_idx_t	idx_client_mate_name;
	/*  */
	sex_t	client_sex;
	/* 󥹥 */
	sex_t	mnstr_sex;
	/* ߽ NPC  */
	sex_t	rescue_trgt_sex;
	/* β² */
	sex_t	client_family_sex;
	/* ֤ */
	sex_t	client_mate_sex;
	/* ߽ NPC μ */
	mnstr_kind_t	rescue_trgt_kind;

	/* λ֤Υǥå */
	n_msg_idx_t	idx_when_1, idx_when_2;
	/* Υǥå */
	n_msg_idx_t	idx_weapon;
} request_t;

#endif	/* REQUEST_H */
