/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2009 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: MouseMap.cpp,v 1.35 2009/03/11 19:00:53 bowkenken Exp $
***************************************************************/

#ifdef D_WS
# include <WScom.h>
# include <WSCfunctionList.h>
# include <WSCbase.h>

# include <WSCvscrBar.h>
# include <WSCwindow.h>
#endif // D_WS

#ifdef D_GTK
# include <gtk/gtk.h>
#endif // D_GTK

#ifdef D_MFC
# include "xlnl-dows/stdafx.h"
# include "xlnl-dows/xlnl-dows.h"
# include "xlnl-dows/MainFrm.h"
#endif // D_MFC

#include "gmain.h"
#include "replay.h"
#include "party.h"
#include "draw.h"
#include "menu.h"
#include "gmain-prot.h"
#include "replay-prot.h"
#include "party-prot.h"
#include "draw-prot.h"
#include "menu-prot.h"
#include "mmenu-prot.h"
#include "imenu-prot.h"

#include "GraphConf.h"
#include "MouseMap.h"
#include "Key.h"
#include "GlobalVar.h"

#ifdef D_GTK
# include "main-gtk-prot.h"
#endif // D_GTK

#ifdef D_MFC
# include "main-dows-prot.h"
#endif // D_MFC

////////////////////////////////////////////////////////////////

#ifdef D_WS
extern WSCwindow* MenuWin;
extern WSCvscrBar *MapScrollX;
extern WSCvscrBar *MapScrollY;
#endif // D_WS

bool bFlagPressTimerRunning;
bool bFlagPressTimer[MouseMotion::nMouseButtonMaxN];

#ifdef D_GTK
gint nPressTimer;
#endif // D_GTK

////////////////////////////////////////////////////////////////
// ޥΥ롦Хåν
////////////////////////////////////////////////////////////////

void initMouseMotionFunc()
{
	bFlagPressTimerRunning = false;
	for( long i = (long)MouseMotion::nMouseButtonMinN;
			i < (long)MouseMotion::nMouseButtonMaxN; i++ ){
		bFlagPressTimer[i] = false;
	}

#ifdef D_GTK
	nPressTimer = 0;
#endif // D_GTK

	// ݥ

	gMouseMotion.setFuncPoint(
			funcMotionPoint );

	// ɥå

	gMouseMotion.setFunc(
			MouseMotion::nMouseButtonL,
			MouseMotion::nMotionDrag,
			funcMotionDragL );

	// ܥκɥåΥ롦Хå

	gMouseMotion.setFunc(
			MouseMotion::nMouseButtonR,
			MouseMotion::nMotionLeft,
			funcMotionLeftR );

	// ܥαɥåΥ롦Хå

	gMouseMotion.setFunc(
			MouseMotion::nMouseButtonR,
			MouseMotion::nMotionRight,
			funcMotionRightR );

	// ܥξɥåΥ롦Хå

	gMouseMotion.setFunc(
			MouseMotion::nMouseButtonR,
			MouseMotion::nMotionUp,
			funcMotionUpR );

	// ܥβɥåΥ롦Хå

	gMouseMotion.setFunc(
			MouseMotion::nMouseButtonR,
			MouseMotion::nMotionDown,
			funcMotionDownR );

	// å

	gMouseMotion.setFuncClick(
			MouseMotion::nMouseButtonL,
			funcMotionClick );

	// 楯å

	gMouseMotion.setFuncClick(
			MouseMotion::nMouseButtonM,
			funcMotionClick );

	// å

	gMouseMotion.setFuncClick(
			MouseMotion::nMouseButtonR,
			funcMotionClick );

	// å

	long btnMin = (long)MouseMotion::nMouseButton3;
	long btnMax = (long)MouseMotion::nMouseButtonMaxN;
	for( long i = btnMin; i < btnMax; i++ ){
		gMouseMotion.setFuncClick(
				(MouseMotion::MouseButtonN)i,
				funcMotionClick );
	}

	// ֥롦å

	gMouseMotion.setFuncDoubleClick(
			MouseMotion::nMouseButtonL,
			funcMotionDoubleClick );

	// ץ쥹

	gMouseMotion.setFuncPress(
			MouseMotion::nMouseButtonL,
			funcMotionPress );

	// ץ쥹

	gMouseMotion.setFuncPress(
			MouseMotion::nMouseButtonM,
			funcMotionPress );

	// ץ쥹

	gMouseMotion.setFuncPress(
			MouseMotion::nMouseButtonR,
			funcMotionPress );

	// ꡼

	gMouseMotion.setFuncRelease(
			MouseMotion::nMouseButtonL,
			funcMotionRelease );

	// ꡼

	gMouseMotion.setFuncRelease(
			MouseMotion::nMouseButtonM,
			funcMotionRelease );

	// ꡼

	gMouseMotion.setFuncRelease(
			MouseMotion::nMouseButtonR,
			funcMotionRelease );

	// ץ쥹 + å

	gMouseMotion.setFuncClickLR(
			MouseMotion::nMouseButtonL,
			funcMotionClickLR );

	// ץ쥹 + å

	gMouseMotion.setFuncClickLR(
			MouseMotion::nMouseButtonR,
			funcMotionClickLR );

	// 

	gMouseMotion.setFuncScroll(
			MouseMotion::nScrollLeft,
			funcMotionScroll );

	// 

	gMouseMotion.setFuncScroll(
			MouseMotion::nScrollRight,
			funcMotionScroll );

	// 她

	gMouseMotion.setFuncScroll(
			MouseMotion::nScrollUp,
			funcMotionScroll );

	// 

	gMouseMotion.setFuncScroll(
			MouseMotion::nScrollDown,
			funcMotionScroll );
}

////////////////////////////////////////////////////////////////
// ޥˤݥȤΥ롦Хå
// long m : ޥܥֹ
// long nBgnX : ɥå X ɸ
// long nBgnY : ɥå Y ɸ
// long nCurX : ߤ X ɸ
// long nCurY : ߤ Y ɸ
////////////////////////////////////////////////////////////////

void funcMotionPoint(
	long m,
	long nBgnX, long nBgnY,
	long nCurX, long nCurY
)
{
	if( get_flg_draw_menu() )
		return;

	// ޥåסΰư

#ifdef D_MFC
	nCurX = nCurX * _100_PERCENT / g_Dir3d.nTileSizeRate;
	nCurY = nCurY * _100_PERCENT / g_Dir3d.nTileSizeRate;
#endif // D_MFC

	long x = gPcgDun.getScrollBarX();
	long y = gPcgDun.getScrollBarY();
	long w = gPcgDun.getScrollBarW();
	long h = gPcgDun.getScrollBarH();

	if( nCurX < 0 )
		return;
	if( nCurY < 0 )
		return;
	if( nCurX >= w )
		return;
	if( nCurY >= h )
		return;

	long mapX = (x + nCurX) / gPcgDun.getTileSizeX( true );
	long mapY = (y + nCurY) / gPcgDun.getTileSizeY( true );
	long mapX2 = (x + w) / gPcgDun.getTileSizeX( true );
	long mapY2 = (y + h) / gPcgDun.getTileSizeY( true );

	if( mapX >= mapX2 )
		return;
	if( mapY >= mapY2 )
		return;

	gKey.moveCrsrAbs( mapX, mapY );

	// ơС˥ҥȤɽ

	printMapStatBar( "%s    %s",
			get_str_map_hint_obj( mapX, mapY ),
			get_str_map_hint_chr( mapX, mapY ) );
}

////////////////////////////////////////////////////////////////
// ɥåΥ롦Хå
// long m : ޥܥֹ
// long nBgnX : ɥå X ɸ
// long nBgnY : ɥå Y ɸ
// long nCurX : ߤ X ɸ
// long nCurY : ߤ Y ɸ
////////////////////////////////////////////////////////////////

void funcMotionDragL(
	long m,
	long nBgnX, long nBgnY,
	long nCurX, long nCurY
)
{
	long maxX = gPcgDun.getScrollBarMaxX();
	long maxY = gPcgDun.getScrollBarMaxY();
	long dx = nCurX - nBgnX;
	long dy = nCurY - nBgnY;
#ifdef D_MFC
	dx = dx * _100_PERCENT / g_Dir3d.nTileSizeRate;
	dy = dy * _100_PERCENT / g_Dir3d.nTileSizeRate;
#endif // D_MFC
	long x = gMapDragBgnX - dx;
	long y = gMapDragBgnY - dy;
	long w = gPcgDun.getScrollBarW();
	long h = gPcgDun.getScrollBarH();

	if( x < 0 )
		x = 0;
	if( y < 0 )
		y = 0;
	if( x > maxX)
		x = maxX;
	if( y > maxY)
		y = maxY;

	long sizX = gPcgDun.getTileSizeX( true );
	long sizY = gPcgDun.getTileSizeY( true );
	x = (x / sizX) * sizX;
	y = (y / sizY) * sizY;

	if( gPcgDun.chkScroll( x, y, w, h ) )
		gPcgDun.scrollMap( x, y );
}

////////////////////////////////////////////////////////////////
// ܥκɥåΥ롦Хå
// long m : ޥܥֹ
// long nBgnX : ɥå X ɸ
// long nBgnY : ɥå Y ɸ
// long nCurX : ߤ X ɸ
// long nCurY : ߤ Y ɸ
////////////////////////////////////////////////////////////////

void funcMotionLeftR(
	long m,
	long nBgnX, long nBgnY,
	long nCurX, long nCurY
)
{
	callFuncKey( FUNC_N_MOTION_LEFT );
}

////////////////////////////////////////////////////////////////
// ܥαɥåΥ롦Хå
// long m : ޥܥֹ
// long nBgnX : ɥå X ɸ
// long nBgnY : ɥå Y ɸ
// long nCurX : ߤ X ɸ
// long nCurY : ߤ Y ɸ
////////////////////////////////////////////////////////////////

void funcMotionRightR(
	long m,
	long nBgnX, long nBgnY,
	long nCurX, long nCurY
)
{
	callFuncKey( FUNC_N_MOTION_RIGHT );
}

////////////////////////////////////////////////////////////////
// ܥξɥåΥ롦Хå
// long m : ޥܥֹ
// long nBgnX : ɥå X ɸ
// long nBgnY : ɥå Y ɸ
// long nCurX : ߤ X ɸ
// long nCurY : ߤ Y ɸ
////////////////////////////////////////////////////////////////

void funcMotionUpR(
	long m,
	long nBgnX, long nBgnY,
	long nCurX, long nCurY
)
{
	callFuncKey( FUNC_N_MOTION_UP );
}

////////////////////////////////////////////////////////////////
// ܥβɥåΥ롦Хå
// long m : ޥܥֹ
// long nBgnX : ɥå X ɸ
// long nBgnY : ɥå Y ɸ
// long nCurX : ߤ X ɸ
// long nCurY : ߤ Y ɸ
////////////////////////////////////////////////////////////////

void funcMotionDownR(
	long m,
	long nBgnX, long nBgnY,
	long nCurX, long nCurY
)
{
	callFuncKey( FUNC_N_MOTION_DOWN );
}

////////////////////////////////////////////////////////////////
// åΥ롦Хå
// long m : ޥܥֹ
// long nBgnX : ɥå X ɸ
// long nBgnY : ɥå Y ɸ
// long nCurX : ߤ X ɸ
// long nCurY : ߤ Y ɸ
////////////////////////////////////////////////////////////////

void funcMotionClick(
	long m,
	long nBgnX, long nBgnY,
	long nCurX, long nCurY
)
{
	MouseMotion::MouseButtonN n = (MouseMotion::MouseButtonN)m;

	if( get_scene() == SCENE_N_GAME_OVER_END ){
		gKey.setChar( 'Q' - '@' );
		return;
	}

	if( n < MouseMotion::nMouseButton0 )
		return;
	if( n >= MouseMotion::nMouseButtonMaxN )
		return;

#if	0
//@@@
	if( n == MouseMotion::nMouseButtonL ){
		gKey.setChar( 'M' - '@' );
	} else if( n == MouseMotion::nMouseButtonM ){
		gKey.setString( "+" );
	} else if( n == MouseMotion::nMouseButtonR ){
		gKey.setString( "." );
	} else if( n == MouseMotion::nMouseButton3 ){
print_msg( 0, "33333" );//@@@
		gKey.setString( "Q" );
	} else if( n == MouseMotion::nMouseButton4 ){
print_msg( 0, "44444" );//@@@
		gKey.setString( "Q" );
	} else if( n == MouseMotion::nMouseButton5 ){
print_msg( 0, "55555" );//@@@
		gKey.setString( "Q" );
	} else if( n == MouseMotion::nMouseButton6 ){
		gKey.setString( "6" );
	} else {
		char str[15 + 1];
		sprintf( str, "&%2ld", (long)n );
		gKey.setString( str );
	}
#else
	if( chk_scene_group( SCENE_GROUP_N_SEL_GRAPH ) ){
		if( n == MouseMotion::nMouseButtonL )
			gSelMbrGraph->sel( nBgnX, nBgnY );
		if( n == MouseMotion::nMouseButtonR )
			gSelMbrGraph->cancel();
	} else {
		callFuncKey( FUNC_N_CLICK_0 + n );
	}
#endif
}

////////////////////////////////////////////////////////////////
// ֥롦åΥ롦Хå
// long m : ޥܥֹ
// long nBgnX : ɥå X ɸ
// long nBgnY : ɥå Y ɸ
// long nCurX : ߤ X ɸ
// long nCurY : ߤ Y ɸ
////////////////////////////////////////////////////////////////

void funcMotionDoubleClick(
	long m,
	long nBgnX, long nBgnY,
	long nCurX, long nCurY
)
{
	MouseMotion::MouseButtonN n = (MouseMotion::MouseButtonN)m;

	if( n < MouseMotion::nMouseButton0 )
		return;
	if( n >= MouseMotion::nMouseButtonMaxN )
		return;

	if( chk_scene_group( SCENE_GROUP_N_SEL_GRAPH ) ){
		if( n == MouseMotion::nMouseButtonL )
			gSelMbrGraph->ok();
	} else {
		if( n == MouseMotion::nMouseButtonL ){
			unset_square_pos();
			gKey.setChar( 'M' - '@' );
		}
	}
}

////////////////////////////////////////////////////////////////
// ƱåΥ롦Хå
// long m : ˥ץ쥹ޥܥֹ
// long nBgnX : ɥå X ɸ
// long nBgnY : ɥå Y ɸ
// long nCurX : ߤ X ɸ
// long nCurY : ߤ Y ɸ
////////////////////////////////////////////////////////////////

void funcMotionClickLR(
	long m,
	long nBgnX, long nBgnY,
	long nCurX, long nCurY
)
{
	if( get_flg_play_replay() ){
		gKey.setString( "," );
		return;
	}

	MouseMotion::MouseButtonN n = (MouseMotion::MouseButtonN)m;

#if	1
	long fn = FUNC_N_CLICK_0;

	if( n == MouseMotion::nMouseButtonL )
		fn = FUNC_N_PRESS_L_CLICK_R;
	else if( n == MouseMotion::nMouseButtonR )
		fn = FUNC_N_PRESS_R_CLICK_L;
	else
		return;

	callFuncKey( fn );
#else
//@@@
	if( n == MouseMotion::nMouseButtonL ){
		gKey.setStringKeyTab( "&11" );
	}

	if( n == MouseMotion::nMouseButtonR ){
		gKey.setStringKeyTab( "&12" );
	}
#endif
}

////////////////////////////////////////////////////////////////
// ץ쥹Υ롦Хå
// long m : ޥܥֹ
// long nBgnX : ɥå X ɸ
// long nBgnY : ɥå Y ɸ
// long nCurX : ߤ X ɸ
// long nCurY : ߤ Y ɸ
////////////////////////////////////////////////////////////////

void funcMotionPress(
	long m,
	long nBgnX, long nBgnY,
	long nCurX, long nCurY
)
{
	MouseMotion::MouseButtonN n = (MouseMotion::MouseButtonN)m;

	if( n < MouseMotion::nMouseButton0 )
		return;
	if( n >= MouseMotion::nMouseButtonMaxN )
		return;

	beginPressTimer( n );
}

////////////////////////////////////////////////////////////////
// ꡼Υ롦Хå
// long m : ޥܥֹ
// long nBgnX : ɥå X ɸ
// long nBgnY : ɥå Y ɸ
// long nCurX : ߤ X ɸ
// long nCurY : ߤ Y ɸ
////////////////////////////////////////////////////////////////

void funcMotionRelease(
	long m,
	long nBgnX, long nBgnY,
	long nCurX, long nCurY
)
{
	MouseMotion::MouseButtonN n = (MouseMotion::MouseButtonN)m;

	if( n < MouseMotion::nMouseButton0 )
		return;
	if( n >= MouseMotion::nMouseButtonMaxN )
		return;

	endPressTimer( n );

	callFuncKey( FUNC_N_RELEASE_0 + n );
}

////////////////////////////////////////////////////////////////
// ץ쥹Υޡγ
// MouseMotion::MouseButtonN n : ޥܥֹ
////////////////////////////////////////////////////////////////

void beginPressTimer( MouseMotion::MouseButtonN n )
{
	if( n < MouseMotion::nMouseButton0 )
		return;
	if( n >= MouseMotion::nMouseButtonMaxN )
		return;

	bFlagPressTimerRunning = false;

	if( bFlagPressTimerRunning ){
#ifdef D_GTK
		gtk_timeout_remove( nPressTimer );
#endif // D_GTK
#ifdef D_MFC
	::timeEndPeriod( theApp.m_pMainFrm->nPressTimer );
#endif // D_MFC
	}

	bFlagPressTimer[n] = true;
	bFlagPressTimerRunning = true;

#ifdef D_GTK
	nPressTimer = gtk_timeout_add(
			1000 * PRESS_TIMER_FRAME_RATE / 60,
			callBackPressTimerGtk, NULL );
#endif // D_GTK
#ifdef D_MFC
	::timeBeginPeriod( theApp.m_pMainFrm->nPressTimer );
#endif // D_MFC
}

////////////////////////////////////////////////////////////////
// ץ쥹Υޡνλ
// MouseMotion::MouseButtonN n : ޥܥֹ
////////////////////////////////////////////////////////////////

void endPressTimer( MouseMotion::MouseButtonN n )
{
	if( n < MouseMotion::nMouseButton0 )
		return;
	if( n >= MouseMotion::nMouseButtonMaxN )
		return;

	bFlagPressTimer[n] = false;

	bool flagPress = false;
	for( long i = (long)MouseMotion::nMouseButtonMinN;
			i < (long)MouseMotion::nMouseButtonMaxN; i++ ){
		if( bFlagPressTimer[i] ){
			flagPress = true;
			break;
		}
	}

	if( !flagPress && bFlagPressTimerRunning ){
		bFlagPressTimerRunning = false;
#ifdef D_GTK
		gtk_timeout_remove( nPressTimer );
#endif // D_GTK
#ifdef D_MFC
		::timeEndPeriod( theApp.m_pMainFrm->nPressTimer );
#endif // D_MFC
	}
}

////////////////////////////////////////////////////////////////
// ֥ץ쥹줿ν (GTK+)
// gpointer data : 롦ХåϿ줿Υǡ
// return : ?
////////////////////////////////////////////////////////////////

#ifdef D_GTK
gint callBackPressTimerGtk( gpointer data )
{
	callBackPressTimer();

	return 0;
}
#endif // D_GTK

////////////////////////////////////////////////////////////////
// ֥ץ쥹줿ν
////////////////////////////////////////////////////////////////

void callBackPressTimer( void )
{
#ifdef D_GTK
	gtk_timeout_remove( nPressTimer );
#endif // D_GTK
#ifdef D_MFC
	::timeEndPeriod( theApp.m_pMainFrm->nPressTimer );
#endif // D_MFC

	if( !bFlagPressTimerRunning )
		return;

	bFlagPressTimerRunning = false;

	for( long i = (long)MouseMotion::nMouseButtonMinN;
			i < (long)MouseMotion::nMouseButtonMaxN; i++ ){
		if( bFlagPressTimer[i] )
			callFuncKey( FUNC_N_PRESS_0 + i );

		bFlagPressTimer[i] = false;
	}
}

////////////////////////////////////////////////////////////////
// Υ롦Хå
// long m : 
// long nBgnX : ɥå X ɸ
// long nBgnY : ɥå Y ɸ
// long nCurX : ߤ X ɸ
// long nCurY : ߤ Y ɸ
////////////////////////////////////////////////////////////////

void funcMotionScroll(
	long m,
	long nBgnX, long nBgnY,
	long nCurX, long nCurY
)
{
	MouseMotion::ScrollKind dir = (MouseMotion::ScrollKind)m;

	if( dir < MouseMotion::nScrollKindMinN )
		return;
	if( dir >= MouseMotion::nScrollKindMaxN )
		return;

	if( gKey.chkBuf() )
		return;
	if( chk_key_buf() )
		return;
	if( chk_executing_menu() )
		return;

	switch( dir ){
	case MouseMotion::nScrollLeft:
		gKey.setString( ":/misc/cursor/cursor/scroll/west\n" );
		break;
	case MouseMotion::nScrollRight:
		gKey.setString( ":/misc/cursor/cursor/scroll/east\n" );
		break;
	case MouseMotion::nScrollUp:
		gKey.setString( ":/misc/cursor/cursor/scroll/north\n" );
		break;
	case MouseMotion::nScrollDown:
		gKey.setString( ":/misc/cursor/cursor/scroll/south\n" );
		break;
	default:
		break;
	}
}

////////////////////////////////////////////////////////////////
// ޥ⡼ե󥯥󡦥Ѵ
// long fn : ե󥯥󡦥ֹ
// return : 顼̵ä?
////////////////////////////////////////////////////////////////

bool callFuncKey( long fn )
{
	if( fn < 0 )
		return false;
	if( fn > FUNC_KEY_MAX )
		return false;

	char str[15 + 1];
	sprintf( str, "&%2ld", (long)fn );
	gKey.setString( str );

	return true;
}
