/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.logviewer.actions;

import jp.sourceforge.logviewer.Activator;
import jp.sourceforge.logviewer.actions.Messages;
import jp.sourceforge.logviewer.util.Util;
import jp.sourceforge.logviewer.views.LogViewerEntry;
import jp.sourceforge.logviewer.views.LogViewerView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Shell;

public class RemoveAction
extends Action {
    private final LogViewerView view;

    public RemoveAction(LogViewerView view) {
        this.setText(Messages.getString("RemoveAction.0"));
        this.setToolTipText(Messages.getString("RemoveAction.1"));
        this.setDescription(Messages.getString("RemoveAction.2"));
        this.setEnabled(true);
        this.setDisabledImageDescriptor(Activator.createImageDescriptor("icons/disable/remove.gif"));
        this.setImageDescriptor(Activator.createImageDescriptor("icons/enable/remove.gif"));
        this.view = view;
    }

    public void run() {
        LogViewerEntry entry = this.view.getSelectedEntry();
        if (entry != null) {
            CTabItem tabItem = entry.getTabItem();
            String fileName = entry.getViewFile().getName();
            boolean judge = MessageDialog.openQuestion((Shell)this.view.getViewSite().getShell(), (String)Messages.getString("RemoveAction.5"), (String)(String.valueOf(Messages.getString("RemoveAction.6")) + fileName + Messages.getString("RemoveAction.7")));
            if (judge) {
                entry.dispose();
                this.view.removeEntry(entry);
                tabItem.dispose();
                try {
                    this.view.saveEntry();
                }
                catch (Exception e) {
                    Util.log(4, "Remove Action", e);
                }
            }
        }
    }
}

