/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.logviewer.dialogs;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.logviewer.Activator;
import jp.sourceforge.logviewer.dialogs.Messages;
import jp.sourceforge.logviewer.filters.Filter;
import jp.sourceforge.logviewer.util.Util;
import jp.sourceforge.logviewer.views.LogViewerEntry;
import jp.sourceforge.logviewer.views.LogViewerEntryConfig;
import jp.sourceforge.logviewer.views.LogViewerView;
import jp.sourceforge.logviewer.wedget.FilterTableContentProvider;
import jp.sourceforge.logviewer.wedget.FilterTableLabelProvider;
import jp.sourceforge.logviewer.wizard.CreateFilterWizard;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class NewViewerDialog
extends Dialog {
    private final boolean replaceMode;
    private final LogViewerEntry entry;
    private Combo fileCombo;
    private Text intervalText;
    private Combo encCombo;
    private TableViewer tableViewer;
    private List<Filter> filterList;

    public NewViewerDialog(Shell shell, LogViewerEntry entry) {
        super(shell);
        this.replaceMode = entry != null;
        this.entry = entry;
    }

    protected void okPressed() {
        String originalFilePath = this.fileCombo.getText();
        String intervalString = this.intervalText.getText();
        String encoding = this.encCombo.getText();
        if (originalFilePath.equals("") || intervalString.equals("") || encoding.equals("")) {
            return;
        }
        String filePath = Util.convertDatePattern(originalFilePath);
        File file = new File(filePath);
        int interval = Integer.parseInt(intervalString);
        LogViewerView view = Activator.getViewer();
        if (this.replaceMode) {
            this.entry.clearFilter();
            TableItem[] tableItemArray = this.tableViewer.getTable().getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                Filter filter = (Filter)item.getData();
                this.entry.addFilter(filter);
                ++n2;
            }
            Activator.getViewer().refresh(this.entry);
            Activator.getViewer().scroll(this.entry);
        } else {
            ArrayList<Filter> fl = new ArrayList<Filter>();
            TableItem[] tableItemArray = this.tableViewer.getTable().getItems();
            int n = tableItemArray.length;
            int n3 = 0;
            while (n3 < n) {
                TableItem item = tableItemArray[n3];
                Filter filter = (Filter)item.getData();
                fl.add(filter);
                ++n3;
            }
            String filterName = "";
            if (fl.size() > 0) {
                filterName = ((Filter)fl.get(0)).getName();
            }
            LogViewerEntryConfig config = new LogViewerEntryConfig(originalFilePath, file, filterName, encoding, interval);
            LogViewerEntry entry = view.createEntry(config, fl);
            view.addEntry(entry);
            entry.watchStart();
        }
        try {
            view.saveEntry();
        }
        catch (Exception e) {
            Util.log(4, "config.xml save error.", e);
        }
        super.okPressed();
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.replaceMode) {
            newShell.setText(Messages.getString("NewViewerDialog.5"));
        } else {
            newShell.setText(Messages.getString("NewViewerDialog.6"));
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 5;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        this.createFileSelectionRow(composite);
        this.createIntervalRow(composite);
        this.createFileHint(composite);
        this.createFilterRow(composite);
        return composite;
    }

    private void createFileSelectionRow(Composite composite) {
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 300;
        gridData.horizontalAlignment = 4;
        new Label(composite, 0).setText(Messages.getString("NewViewerDialog.7"));
        this.fileCombo = new Combo(composite, 4);
        this.fileCombo.setLayoutData((Object)gridData);
        Button chooserButton = new Button(composite, 8);
        chooserButton.setText(Messages.getString("NewViewerDialog.8"));
        if (this.replaceMode) {
            this.fileCombo.setEnabled(false);
            chooserButton.setEnabled(false);
            this.fileCombo.setText(this.entry.getOriginalFilePath());
        }
        chooserButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog dialog = new FileDialog(NewViewerDialog.this.getShell(), 4);
                dialog.open();
                if (dialog.getFileName().length() > 0) {
                    NewViewerDialog.this.fileCombo.setText(String.valueOf(dialog.getFilterPath()) + File.separator + dialog.getFileName());
                }
            }
        });
    }

    private void createFileHint(Composite composite) {
        Group fileHintGroup = new Group(composite, 0);
        fileHintGroup.setText(Messages.getString("NewViewerDialog.9"));
        GridLayout glayout = new GridLayout(1, false);
        fileHintGroup.setLayout((Layout)glayout);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        fileHintGroup.setLayoutData((Object)gridData);
        new Label((Composite)fileHintGroup, 0).setText(Messages.getString("NewViewerDialog.10"));
        new Label((Composite)fileHintGroup, 0).setText(Messages.getString("NewViewerDialog.11"));
    }

    private void createFilterRow(Composite composite) {
        Group filterGroup = new Group(composite, 0);
        filterGroup.setText(Messages.getString("NewViewerDialog.12"));
        GridLayout glayout = new GridLayout(2, false);
        filterGroup.setLayout((Layout)glayout);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        filterGroup.setLayoutData((Object)gridData);
        this.tableViewer = new TableViewer((Composite)filterGroup, 68356);
        this.filterList = new ArrayList<Filter>();
        Table filterTable = this.tableViewer.getTable();
        this.tableViewer.setContentProvider((IContentProvider)new FilterTableContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new FilterTableLabelProvider(filterTable));
        String[] properties = new String[]{"check", "text"};
        this.tableViewer.setColumnProperties(properties);
        this.tableViewer.setCellEditors(new CellEditor[]{new CheckboxCellEditor((Composite)filterTable), new TextCellEditor((Composite)filterTable)});
        this.tableViewer.setInput(this.filterList);
        this.tableViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return property.equals("check");
            }

            public Object getValue(Object element, String property) {
                Filter filter = (Filter)element;
                if (property.equals("check")) {
                    return filter.isEnabled();
                }
                if (property.equals("text")) {
                    return filter.getName();
                }
                return null;
            }

            public void modify(Object element, String property, Object value) {
                TableItem item = (TableItem)element;
                Filter filter = (Filter)item.getData();
                if (property.equals("check")) {
                    filter.setEnabled((Boolean)value);
                    NewViewerDialog.this.tableViewer.update((Object)filter, null);
                }
            }
        });
        filterTable.setHeaderVisible(true);
        filterTable.setLinesVisible(true);
        TableColumn enabledColumn = new TableColumn(filterTable, 0x1000000, 0);
        enabledColumn.setWidth(30);
        enabledColumn.setText(Messages.getString("NewViewerDialog.19"));
        TableColumn keywordColumn = new TableColumn(filterTable, 16384, 1);
        keywordColumn.setWidth(250);
        keywordColumn.setText(Messages.getString("NewViewerDialog.20"));
        GridData gridData2 = new GridData();
        gridData2 = new GridData(512);
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.horizontalAlignment = 4;
        gridData2.verticalAlignment = 4;
        gridData2.verticalSpan = 3;
        filterTable.setLayoutData((Object)gridData2);
        Button newButton = new Button((Composite)filterGroup, 8);
        newButton.setText(Messages.getString("NewViewerDialog.21"));
        newButton.setLayoutData((Object)new GridData(2));
        newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CreateFilterWizard wizard = new CreateFilterWizard(null);
                WizardDialog dialog = new WizardDialog(NewViewerDialog.this.getShell(), (IWizard)wizard);
                dialog.open();
                Filter filter = wizard.getFilter();
                NewViewerDialog.this.tableViewer.add((Object)filter);
                wizard.dispose();
            }
        });
        final Button editButton = new Button((Composite)filterGroup, 8);
        editButton.setText(Messages.getString("NewViewerDialog.22"));
        editButton.setLayoutData((Object)new GridData(2));
        editButton.setEnabled(false);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                editButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableItem[] tableItems = NewViewerDialog.this.tableViewer.getTable().getSelection();
                if (tableItems.length > 0) {
                    Filter oldFilter = (Filter)tableItems[0].getData();
                    CreateFilterWizard wizard = new CreateFilterWizard(oldFilter);
                    WizardDialog dialog = new WizardDialog(NewViewerDialog.this.getShell(), (IWizard)wizard);
                    int result = dialog.open();
                    if (result == 0) {
                        Filter newFilter = wizard.getFilter();
                        NewViewerDialog.this.tableViewer.remove((Object)oldFilter);
                        NewViewerDialog.this.tableViewer.add((Object)newFilter);
                    }
                    wizard.dispose();
                }
            }
        });
        final Button removeButton = new Button((Composite)filterGroup, 8);
        removeButton.setText(Messages.getString("NewViewerDialog.23"));
        removeButton.setLayoutData((Object)new GridData(2));
        removeButton.setEnabled(false);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                removeButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = NewViewerDialog.this.tableViewer.getTable().getSelectionIndex();
                if (index > -1) {
                    NewViewerDialog.this.tableViewer.getTable().remove(index);
                }
            }
        });
        Button removeAllButton = new Button((Composite)filterGroup, 8);
        removeAllButton.setText(Messages.getString("NewViewerDialog.24"));
        removeAllButton.setLayoutData((Object)new GridData(2));
        removeAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewViewerDialog.this.tableViewer.getTable().removeAll();
            }
        });
        if (this.replaceMode) {
            for (Filter filter : this.entry.getFilterList()) {
                this.tableViewer.add((Object)filter);
            }
        }
    }

    private void createIntervalRow(Composite composite) {
        Label intervalLabel = new Label(composite, 0);
        intervalLabel.setText(Messages.getString("NewViewerDialog.25"));
        GridData gridData = new GridData();
        gridData.widthHint = 20;
        this.intervalText = new Text(composite, 2048);
        this.intervalText.setLayoutData((Object)gridData);
        this.intervalText.setTextLimit(3);
        this.intervalText.setText("1");
        this.intervalText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                boolean judge1 = Character.isDigit(event.character);
                boolean judge2 = Character.isISOControl(event.character);
                event.doit = judge1 | judge2;
            }
        });
        Label encLabel = new Label(composite, 0);
        encLabel.setText(Messages.getString("NewViewerDialog.27"));
        this.encCombo = new Combo(composite, 2048);
        this.encCombo.add(System.getProperty("file.encoding"));
        this.encCombo.add("ISO8859_1");
        this.encCombo.add("UTF-8");
        this.encCombo.add("MS932");
        this.encCombo.add("EUC_JP");
        this.encCombo.add("ISO2022JP");
        this.encCombo.select(0);
        if (this.replaceMode) {
            this.intervalText.setText(String.valueOf(this.entry.getWatcher().getInterval() / 1000L));
            String enc = this.entry.getEncoding();
            String[] items = this.encCombo.getItems();
            boolean lookupFlag = false;
            int i = 0;
            int length = items.length;
            while (i < length) {
                if (items[i].equals(enc)) {
                    this.encCombo.select(i);
                    lookupFlag = true;
                    break;
                }
                ++i;
            }
            if (!lookupFlag) {
                this.encCombo.add(enc);
                this.encCombo.select(this.encCombo.getItemCount() - 1);
            }
            this.intervalText.setEnabled(false);
            this.encCombo.setEnabled(false);
        }
    }
}

