/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.logviewer.filters;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.logviewer.filters.FilterAction;
import jp.sourceforge.logviewer.filters.FilterResult;
import org.eclipse.swt.custom.LineStyleEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Filter {
    private boolean enabled = true;
    private String name;
    private final Pattern pattern;
    private final List<FilterAction> filterActionList;

    public Filter(String patternString) {
        this(patternString, 0);
    }

    public Filter(String patternString, int flags) {
        this.name = patternString;
        this.pattern = Pattern.compile(patternString, flags);
        this.filterActionList = new ArrayList<FilterAction>();
    }

    public FilterResult matches(String input) {
        int start = 0;
        int end = 0;
        if (!this.enabled) {
            return new FilterResult(input, false, start, end);
        }
        Matcher matcher = this.pattern.matcher(input);
        boolean judge = matcher.matches();
        if (judge) {
            start = matcher.start();
            end = matcher.end();
        }
        return new FilterResult(input, judge, start, end);
    }

    public FilterResult find(String input) {
        Matcher matcher = this.pattern.matcher(input);
        int start = 0;
        int end = 0;
        if (!this.enabled) {
            return new FilterResult(input, false, start, end);
        }
        boolean judge = matcher.find();
        if (judge) {
            start = matcher.start();
            end = matcher.end();
        }
        return new FilterResult(input, judge, start, end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyMatches(LineStyleEvent event, FilterResult result) {
        List<FilterAction> list = this.filterActionList;
        synchronized (list) {
            for (FilterAction filterAction : this.filterActionList) {
                filterAction.doAction(event, result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addFilterAction(FilterAction filterAction) {
        List<FilterAction> list = this.filterActionList;
        synchronized (list) {
            return this.filterActionList.add(filterAction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeFilterAction(FilterAction filterAction) {
        List<FilterAction> list = this.filterActionList;
        synchronized (list) {
            return this.filterActionList.remove(filterAction);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getPatternString() {
        return this.pattern.pattern();
    }

    public List<FilterAction> getFilterActionList() {
        return this.filterActionList;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("pattern:").append(this.pattern.pattern()).append(" ");
        builder.append("actionCount:").append(this.filterActionList.size()).append(" ");
        builder.append("actions{");
        for (FilterAction filterAction : this.filterActionList) {
            builder.append(filterAction.toString()).append(",");
        }
        builder.append("}");
        return builder.toString();
    }
}

