/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.logviewer.filters;

import java.util.ArrayList;
import jp.sourceforge.logviewer.filters.FilterAction;
import jp.sourceforge.logviewer.filters.FilterResult;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;

public class TextStyleFilterAction
implements FilterAction {
    private boolean enabled;
    private final Color foreColor;
    private final Color backColor;
    private final int fontStyle;

    public TextStyleFilterAction(Color foreColor, Color backColor) {
        this(foreColor, backColor, 0);
    }

    public TextStyleFilterAction(Color foreColor, Color backColor, int fontStyle) {
        this.foreColor = foreColor;
        this.backColor = backColor;
        this.fontStyle = fontStyle;
        this.enabled = true;
    }

    public void doAction(LineStyleEvent event, FilterResult result) {
        if (!this.enabled) {
            return;
        }
        int offset = event.lineOffset;
        int start = result.getStart();
        int end = result.getEnd();
        StyleRange range = new StyleRange(offset + start, end - start, this.foreColor, this.backColor, this.fontStyle);
        ArrayList<StyleRange> styleRangeList = new ArrayList<StyleRange>();
        if (event.styles != null) {
            StyleRange[] styleRangeArray = event.styles;
            int n = event.styles.length;
            int n2 = 0;
            while (n2 < n) {
                StyleRange r = styleRangeArray[n2];
                styleRangeList.add(r);
                ++n2;
            }
        }
        styleRangeList.add(range);
        event.styles = styleRangeList.toArray(new StyleRange[0]);
    }

    public Color getForeColor() {
        return this.foreColor;
    }

    public Color getBackColor() {
        return this.backColor;
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void dispose() {
        this.foreColor.dispose();
        this.backColor.dispose();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TextStyle [");
        builder.append("foreground:").append(this.foreColor).append(" ");
        builder.append("background:").append(this.backColor).append(" ");
        builder.append("fontStyle:");
        switch (this.fontStyle) {
            case 3: {
                builder.append("BOLD_ITALIC");
                break;
            }
            case 0: {
                builder.append("NORMAL");
                break;
            }
            case 1: {
                builder.append("BOLD");
                break;
            }
            case 2: {
                builder.append("ITALIC");
                break;
            }
            default: {
                builder.append("NORMAL");
            }
        }
        builder.append("]");
        return builder.toString();
    }
}

