/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.logviewer.views;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.logviewer.filters.Filter;
import jp.sourceforge.logviewer.views.LogViewerEntryConfig;
import jp.sourceforge.logviewer.watchers.TextFileWatcher;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.CTabItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogViewerEntry {
    private boolean enabled = true;
    private final LogViewerEntryConfig config;
    private final SourceViewer viewer;
    private final List<Filter> filterList;
    private final CTabItem tabItem;
    private final TextFileWatcher watcher;
    boolean scroll = true;

    public LogViewerEntry(LogViewerEntryConfig config, SourceViewer viewer, List<Filter> filterList, TextFileWatcher watcher, CTabItem tabItem) {
        this.config = config;
        this.viewer = viewer;
        this.filterList = filterList;
        this.tabItem = tabItem;
        this.watcher = watcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addFilter(Filter filter) {
        List<Filter> list = this.filterList;
        synchronized (list) {
            return this.filterList.add(filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeFilter(Filter filter) {
        List<Filter> list = this.filterList;
        synchronized (list) {
            return this.filterList.remove(filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearFilter() {
        List<Filter> list = this.filterList;
        synchronized (list) {
            this.filterList.clear();
        }
    }

    public SourceViewer getViewer() {
        return this.viewer;
    }

    public List<Filter> getFilterList() {
        return new ArrayList<Filter>(this.filterList);
    }

    public File getViewFile() {
        return this.config.getFile();
    }

    public TextFileWatcher getWatcher() {
        return this.watcher;
    }

    public CTabItem getTabItem() {
        return this.tabItem;
    }

    public boolean isScroll() {
        return this.scroll;
    }

    public void setScroll(boolean scroll) {
        this.scroll = scroll;
    }

    public void watchStart() {
        new Thread(this.watcher).start();
    }

    public String getName() {
        return this.config.getEntryName();
    }

    public String getEncoding() {
        return this.config.getEncoding();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.watcher.dispose();
        this.tabItem.dispose();
        List<Filter> list = this.filterList;
        synchronized (list) {
            this.filterList.clear();
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getOriginalFilePath() {
        return this.config.getOriginalFilePath();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("file:");
        builder.append(this.config.getAbsoluteFilePath()).append(" ");
        return builder.toString();
    }
}

