/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.logviewer.views;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.sourceforge.logviewer.Activator;
import jp.sourceforge.logviewer.actions.ClearAction;
import jp.sourceforge.logviewer.actions.EditAction;
import jp.sourceforge.logviewer.actions.NewViewerCreateAction;
import jp.sourceforge.logviewer.actions.RemoveAction;
import jp.sourceforge.logviewer.actions.ScrollLockAction;
import jp.sourceforge.logviewer.filters.Filter;
import jp.sourceforge.logviewer.filters.FilterResult;
import jp.sourceforge.logviewer.util.Util;
import jp.sourceforge.logviewer.util.XmlUtil;
import jp.sourceforge.logviewer.views.LogViewerEntry;
import jp.sourceforge.logviewer.views.LogViewerEntryConfig;
import jp.sourceforge.logviewer.watchers.TextFileWatcher;
import jp.sourceforge.logviewer.watchers.TextUpdateEvent;
import jp.sourceforge.logviewer.watchers.TextUpdateListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.OverviewRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.part.ViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogViewerView
extends ViewPart {
    public static final String CONF_FILE = "config.xml";
    private CTabFolder tabFolder;
    private List<LogViewerEntry> entryList;
    public static final String ANNO_TYPE = "com.mycompany.element";
    public static final String ANNO_KEY_HIGHLIGHT = "annotateElemHighlight";
    public static final String ANNO_KEY_OVERVIEW = "annotateElemOverviewRuler";
    public static final String ANNO_KEY_VERTICAL = "annotateElemVertialRuler";
    public static final String ANNO_KEY_TEXT = "annotateElemText";
    public static final String ANNO_KEY_COLOR = "annotateElemColor";

    public LogViewerView() {
        Activator.setViewer(this);
    }

    public void createPartControl(Composite parent) {
        List<LogViewerEntry> entryList;
        block23: {
            this.entryList = new ArrayList<LogViewerEntry>();
            this.tabFolder = new CTabFolder(parent, 0);
            this.tabFolder.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent event) {
                    LogViewerEntry entry = LogViewerView.this.getSelectedEntry();
                    File viewFile = entry.getViewFile();
                    LogViewerView.this.dispInfoViewFile(viewFile);
                }

                public void widgetSelected(SelectionEvent event) {
                    LogViewerEntry entry = LogViewerView.this.getSelectedEntry();
                    File viewFile = entry.getViewFile();
                    LogViewerView.this.dispInfoViewFile(viewFile);
                }
            });
            Display display = Display.getCurrent();
            this.tabFolder.setSelectionBackground(new Color[]{display.getSystemColor(31), display.getSystemColor(32), display.getSystemColor(22)}, new int[]{60, 100});
            this.tabFolder.setSelectionForeground(display.getSystemColor(30));
            this.tabFolder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

                public void close(CTabFolderEvent event) {
                    super.close(event);
                    CTabFolder tabFolder = (CTabFolder)event.getSource();
                    CTabItem tabItem = tabFolder.getSelection();
                    for (LogViewerEntry entry : LogViewerView.this.entryList) {
                        if (entry.getTabItem() != tabItem) continue;
                        entry.dispose();
                    }
                }
            });
            entryList = null;
            InputStream in = null;
            try {
                try {
                    IPath path = Activator.getDefault().getStateLocation();
                    path = path.addTrailingSeparator();
                    path = path.append(CONF_FILE);
                    File f = path.toFile();
                    if (!f.exists()) {
                        if (f.createNewFile()) {
                            FileOutputStream out = null;
                            try {
                                out = new FileOutputStream(f);
                                XmlUtil.saveEntryList(null, out);
                            }
                            finally {
                                if (out != null) {
                                    ((OutputStream)out).close();
                                }
                            }
                        } else {
                            Util.log(4, "config.xml create error.", null);
                        }
                    }
                    in = new FileInputStream(f);
                    entryList = XmlUtil.createEntryList(in, this);
                }
                catch (Exception e1) {
                    Util.log(4, "config.xml read error.", e1);
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            Util.log(4, "config.xml close error.", e);
                        }
                    }
                    break block23;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        Util.log(4, "config.xml close error.", e);
                    }
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    Util.log(4, "config.xml close error.", e);
                }
            }
        }
        this.createActions();
        if (entryList != null) {
            for (LogViewerEntry entry : entryList) {
                this.addEntry(entry);
                if (!entry.isEnabled()) continue;
                entry.watchStart();
            }
        }
        this.contributeToActionBars();
    }

    public CTabFolder getTabFolder() {
        return this.tabFolder;
    }

    public void dispInfoViewFile(File viewFile) {
        if (viewFile == null) {
            return;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long size = viewFile.length();
        long modified = viewFile.lastModified();
        StringBuilder builder = new StringBuilder();
        builder.append(" - File Information -  ");
        builder.append("[ ").append(viewFile.getName()).append("    ");
        builder.append("Last Modified : ").append(dateFormat.format(new Date(modified))).append("    ");
        builder.append("Size : ");
        if (size > 0x100000L) {
            builder.append(size / 0x100000L).append(" Mbytes ");
        } else if (size > 1024L) {
            builder.append(size / 1024L).append(" Kbytes ");
        } else {
            builder.append(size).append(" bytes ");
        }
        builder.append("]");
        this.setContentDescription(builder.toString());
    }

    private void createActions() {
        Activator.addAction("new", new NewViewerCreateAction(this));
        Activator.addAction("edit", new EditAction(this));
        Activator.addAction("remove", new RemoveAction(this));
        Activator.addAction("clear", new ClearAction(this));
        Activator.addAction("scrollLock", new ScrollLockAction(this));
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)Activator.getAction("new"));
        manager.add((IAction)Activator.getAction("edit"));
        manager.add((IAction)Activator.getAction("remove"));
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IAction)Activator.getAction("clear"));
        manager.add((IAction)Activator.getAction("scrollLock"));
    }

    public void setFocus() {
        this.tabFolder.setFocus();
    }

    public LogViewerEntry getSelectedEntry() {
        CTabItem tabItem = this.tabFolder.getSelection();
        for (LogViewerEntry entry : this.entryList) {
            if (entry.getTabItem() != tabItem) continue;
            return entry;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addEntry(LogViewerEntry entry) {
        List<LogViewerEntry> list = this.entryList;
        synchronized (list) {
            return this.entryList.add(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogViewerEntry getEntry(String entryName) {
        List<LogViewerEntry> list = this.entryList;
        synchronized (list) {
            for (LogViewerEntry entry : this.entryList) {
                if (!entryName.equals(entry.getName())) continue;
                return entry;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntry(LogViewerEntry entry) {
        List<LogViewerEntry> list = this.entryList;
        synchronized (list) {
            if (entry != null) {
                this.entryList.remove(entry);
            }
        }
    }

    public LogViewerEntry createEntry(LogViewerEntryConfig config, List<Filter> filterList) {
        CTabFolder tabFolder = this.getTabFolder();
        CTabItem tabItem = new CTabItem(tabFolder, 0);
        tabItem.setToolTipText(config.getAbsoluteFilePath());
        tabItem.setText(config.getFileName());
        tabItem.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                CTabItem tabItem = (CTabItem)event.getSource();
                LogViewerEntry tmpEntry = null;
                for (LogViewerEntry entry : LogViewerView.this.entryList) {
                    if (entry.getTabItem() != tabItem) continue;
                    tmpEntry = entry;
                    break;
                }
                tmpEntry.dispose();
                LogViewerView.this.removeEntry(tmpEntry);
            }
        });
        tabFolder.setSelection(tabItem);
        final Display display = Display.getCurrent();
        CompositeRuler compositeRuler = new CompositeRuler();
        LineNumberRulerColumn rulerColumn = new LineNumberRulerColumn();
        rulerColumn.setBackground(new Color((Device)display, 230, 230, 230));
        compositeRuler.addDecorator(0, (IVerticalRulerColumn)rulerColumn);
        ISharedTextColors sharedColors = EditorsPlugin.getDefault().getSharedTextColors();
        OverviewRuler overviewRuler = new OverviewRuler(null, 12, sharedColors);
        Document document = new Document();
        AnnotationModel annotationModel = new AnnotationModel();
        annotationModel.connect((IDocument)document);
        SourceViewer viewer = new SourceViewer((Composite)tabFolder, (IVerticalRuler)compositeRuler, (IOverviewRuler)overviewRuler, true, 68354);
        viewer.configure(new SourceViewerConfiguration());
        tabItem.setControl(viewer.getControl());
        viewer.setInput((Object)document);
        TextFileWatcher watcher = new TextFileWatcher(config.getFile(), (long)config.getInterval() * 1000L, config.getEncoding());
        final LogViewerEntry entry = new LogViewerEntry(config, viewer, filterList, watcher, tabItem);
        viewer.getTextWidget().addLineStyleListener(new LineStyleListener(){

            public void lineGetStyle(LineStyleEvent event) {
                for (Filter filter : entry.getFilterList()) {
                    FilterResult result = filter.find(event.lineText);
                    if (!result.isResult()) continue;
                    filter.notifyMatches(event, result);
                }
            }
        });
        watcher.addTextUpdateListener(new TextUpdateListener(){

            public void textUpdated(TextUpdateEvent e) {
                final List<String> updateLine = e.getAppendLine();
                display.asyncExec(new Runnable(){

                    public void run() {
                        SourceViewer viewer = entry.getViewer();
                        for (String line : updateLine) {
                            StyledText styledText = viewer.getTextWidget();
                            String appendText = String.valueOf(line) + System.getProperty("line.separator");
                            styledText.append(appendText);
                            LogViewerView.this.scroll(entry);
                            File viewFile = entry.getViewFile();
                            LogViewerView.this.dispInfoViewFile(viewFile);
                        }
                    }
                });
            }
        });
        return entry;
    }

    public void saveEntry() throws Exception {
        IPath path = Activator.getDefault().getStateLocation();
        path = path.addTrailingSeparator();
        File f = (path = path.append(CONF_FILE)).toFile();
        if (!f.exists() && !f.createNewFile()) {
            Util.log(4, "config.xml create error.", null);
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(f);
            XmlUtil.saveEntryList(this.entryList, out);
        }
        finally {
            if (out != null) {
                ((OutputStream)out).close();
            }
        }
    }

    public void refresh(LogViewerEntry entry) {
        entry.getViewer().refresh();
    }

    public void scroll(LogViewerEntry entry) {
        if (entry.isScroll()) {
            SourceViewer viewer = entry.getViewer();
            StyledText styledText = viewer.getTextWidget();
            viewer.setTopIndex(styledText.getLineCount());
        }
    }

    class ColorCache
    implements ISharedTextColors {
        ColorCache() {
        }

        public Color getColor(RGB rgb) {
            return new Color((Device)Display.getDefault(), rgb);
        }

        public void dispose() {
        }
    }
}

